;
; Plots estimates of the time scale dependent calibration uncertainties
; of the Mann et al. 1999 reconstruction of NH temperature.
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
def_1color,20,color='vlpurple'
def_1color,21,color='magenta'
def_1color,22,color='red'
def_1color,23,color='orange'
def_1color,24,color='green'
def_1color,25,color='brightblue'
def_1color,30,color='blue'
def_1color,31,color='deepblue'
;
; Read in 1000-year reconstruction
;
yrst=1000
yren=1980
nyr=yren-yrst+1
rawdat=fltarr(2,nyr)
openr,1,'mann_nh1000.dat'
readf,1,rawdat
close,1
timey=reform(rawdat[0,*])
nhts=reform(rawdat[1,*])
;
; Read in 1000-year time-dependent errors
;
headst=' '
rawdat=fltarr(5,nyr)
openr,1,'mann_nherr1000.dat'
readf,1,headst
readf,1,rawdat
close,1
if total(abs(timey-rawdat[0,*])) ne 0 then message,'Times do not match'
nholderr=reform(rawdat[1,*])
;
restore,filename='mann_tderr.idlsave'
; Gets: nsca,tsca,nfix,fixedyr,allvif,allerr
;
; Assume each error estimate holds from its date through to the year prior to
; the next estimate (or through to the end of the reconstruction, if its
; the last one).
;
nherr=fltarr(nyr,nsca)
for isca = 0 , nsca-1 do nherr[*,isca]=allerr[isca,0]
for ifix = 1 , nfix-1 do begin
  ist=where(timey eq fixedyr[ifix],ngot)
  if ngot ne 1 then message,'Ooops!!!'
  ist=ist[0]
  for isca = 0 , nsca-1 do nherr[ist:*,isca]=allerr[isca,ifix]
endfor
;
;if 0 eq 1 then begin
plot,timey,nholderr,thick=3,$
  /xstyle,xtitle='Year',$
  ytitle='Reconstruction standard error  (K)',$
  title='Mann et al. (1999) NH temperature reconstruction errors'
for isca = 0 , nsca-2 do oplot,timey,nherr[*,isca],thick=3,color=20+isca
;endif
;
for isca = 0 , nsca-2 do begin
  flen=tsca[isca]
  if flen eq 1 then ts1=nhts else filter_cru,flen,/nan,tsin=nhts,tslow=ts1
  er1=nherr[*,isca]
  pause
  plot,timey,ts1,/nodata,$
    /xstyle,xtitle='Year',$
    /ystyle,yrange=[-0.9,0.73],ytitle='Temperature anomaly  (K)',$
    title='Mann et al. (1999) NH temperature reconstruction: '+$
      string(flen,format='(I3)')+' year'
  for i = 2 , 1 , -1 do begin
    xerr=[timey,reverse(timey)]
    yerr=[ts1-i*er1,reverse(ts1+i*er1)]
    polyfill,xerr,yerr,color=29+i
    print,min(yerr),max(yerr)
  endfor
;  axis,xaxis=0,/xstyle
;  axis,xaxis=1,/xstyle
  axis,yaxis=0,/ystyle,ytickformat='nolabels'
  axis,yaxis=1,/ystyle,ytickformat='nolabels'
  oplot,!x.crange,[0,0],linestyle=1
  oplot,timey,ts1,thick=1+2*(isca ne 0)
endfor
;
end
