; FindBounds.pro

MissVal = -999.0

ModelChosen = MissVal
SelectModel, ModelChosen, ModelFilePath, LongN, LatN
LoadGlo, ModelChosen, Data, "", ""

LongMin = LongN + 1
LongMax = -1
LatMin = LatN + 1
LatMax = -1

for XLong = 0, (LongN-1) do begin
  for XLat = 0, (LatN-1) do begin
    if (Data(XLong,XLat) NE MissVal) then begin
      if (XLong LT LongMin) then LongMin = XLong
      if (XLong GT LongMax) then LongMax = XLong
      if (XLat LT LatMin) then LatMin = XLat
      if (XLat GT LatMax) then LatMax = XLat
    endif
  endfor
endfor

print, "  > Info below: cells, first-with-val, last-with-val"
print, "  > Long: ", LongN, LongMin, LongMax
print, "  > Lat:  ", LatN, LatMin, LatMax

end
