pro frs_gts_anom,year1,year2,dtr_prefix=dtr_prefix,tmp_prefix=tmp_prefix,$
    nor1=nor1,nor2=nor2,outprefix=outprefix,dumpbin=dumpbin,dumpglo=dumpglo,$
    dumpratio=dumpratio
    
; calculates ground-frost anomaly time series from tmin, using dtr and tmp
;  to calculate tmin
; then uses anomalies with frost normal grid to calculate monthly frost freq
if n_params() lt 1 then begin
 print,'frs_gts_anom,year1,year2,dtr_prefix=dtr_prefix,tmp_prefix=tmp_prefix,'
 print,'         nor1=nor1,nor2=nor2,outprefix=outprefix,'
 print,'         dumpbin=dumpbin,dumpglo=dumpglo,dumpratio=dumpratio'
 return
endif
close,/all
if keyword_set(nor1) eq 0 then nor1=1961
if keyword_set(nor2) eq 0 then nor2=1990
if keyword_set(outprefix) eq 0 then outprefix='glo.frs.ano.'
outprefix2='glo.frs.'
if keyword_set(dtr_prefix) eq 0 then dtr_prefix='~/m1/gts/dtr/glo/glo.dtr.'
if keyword_set(tmp_prefix) eq 0 then tmp_prefix='~/m1/gts/tmp/glo/glo.tmp.'
;
monthname=strarr(12)
monthname[*]=['01','02','03','04','05','06','07','08','09','10','11','12']
frsmonth=fltarr(144,72)
;
; read in frs normal
rdbin,frsnor,'/cru/tyn1/f014/_keep/glo25.frs.6190',gridsize=2.5,/quiet

nland=where(frsnor gt -9999)
nsea=where(frsnor eq -9999)
frsnor(nland)=frsnor(nland)/10.0

frssyn=float(frsnor)*0.0
frsgrd=float(frsnor)*0.0
tmn   =float(frsnor)*0.0

; calculate 1961-1990 synthetic normal from adjusted tmn
print,'Calculating synthetic frs normal'

for iy=nor1,nor2 do begin
 tmpfl=strip(string(tmp_prefix,iy))
 dtrfl=strip(string(dtr_prefix,iy))
 rdbin,tmpgrd,tmpfl,gridsize=2.5,/quiet
 rdbin,dtrgrd,dtrfl,gridsize=2.5,/quiet

 tmn(nland)=(tmpgrd(nland)-(0.5*dtrgrd(nland)))/10.0
 frssyn(nland)=frssyn(nland)+frscal(tmn(nland))
endfor

frssyn(nland)=frssyn(nland)/(nor2-nor1+1)

for im=0,11 do begin
 temp=frssyn(*,*,im)
 nfin=where(temp gt 0)
 temp(nfin)=(temp(nfin)/100.0)*days(im)
 frssyn(*,*,im)=temp
endfor
frssyn(nsea)=-999.9

;  Calculate synthetic frs from tmin, convert to anomalies 
;  relative to synthetic mean frs, and apply to normal frs
print,'Calculating synthetic anomalies'

for iy=year1,year2 do begin
 yeartext=string(iy,form='(i4)')

 tmpfl=strip(string(tmp_prefix,iy))
 dtrfl=strip(string(dtr_prefix,iy))
 rdbin,tmpgrd,tmpfl,gridsize=2.5,/quiet
 rdbin,dtrgrd,dtrfl,gridsize=2.5,/quiet
 
 tmn(nland)=tmpgrd(nland)/10.0-0.5*dtrgrd(nland)/10.0 
 frsgrd(nland)=frscal(tmn(nland))
 
 for im=0,11 do begin
  temp=frsgrd(*,*,im)
  nfin=where(temp gt 0)
  temp(nfin)=(temp(nfin)/100.0)*days(im)
  frsgrd(*,*,im)=temp
 endfor
 
 if keyword_set(dumpratio) then begin
   frsgrd(nland)=100*(frsgrd(nland)/frssyn(nland))
 endif else begin
   frsgrd(nland)=10*(frsgrd(nland)-frssyn(nland))
 endelse

 frsgrd(nland)=frsgrd(nland)>(-9998)
 frsgrd(nland)=frsgrd(nland)<9998
 frsgrd(nsea)=-9999
 frsgrd=fix(round(frsgrd))

 if keyword_set(dumpbin) then $
   wrbin,frsgrd,strip(string(outprefix,iy))
 
 if keyword_set(dumpglo) then begin
   for imon=0,11 do begin
     frsmonth=frsgrd(*,*,imon)
     if (iy eq year1 and imon eq 0) then monsea=where(frsmonth eq -9999)
     if keyword_set(dumpratio) then begin
       frsmonth=frsmonth/100.0
     endif else begin
       frsmonth=frsmonth/10.0
     endelse
     frsmonth(monsea)=-999.0
     
     SaveFile=outprefix+monthname(imon)+'.'+yeartext+'.glo'
     SaveTitle='synthetic frs for month '+monthname(imon)+' in year '+yeartext
     SaveGlo,23,frsmonth,CallFile=Savefile,CallTitle=SaveTitle
   endfor
 endif
 
endfor

end
