pro makehires,logrid,higrid,loglomask=loglomask, $
	dumpstem=dumpstem,dumpglo=dumpglo,dumpbox=dumpbox

; the program may read from a linearly gridded set of .glo files
; the program dumps using the dumpstem and appropriate suffices
;	set dumpglo (for .glo files) and/or dumpbox (for input to boxtogrim.f90)
; higrid should be set to the index of the linear grid to which to interpolate
; logrid should be set to the index of the linear grid from which to interpolate

monthname=strarr(12)
monthname[*]=['01','02','03','04','05','06','07','08','09','10','11','12']

if (logrid ge 0) then begin
  SelectModel, logrid, lomodelfile, lolongn, lolatn
endif else begin
  logcm = logrid
endelse

if (logrid ge 0) then begin
  if            (logrid eq 103) then begin	; HadCM3 97*73
    lolongn=lolongn & QExtend=0
    lolonglen=3.75 & lolatlen=2.5
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-180.0
    lolat =findgen(lolatn)  & lolat(*) =(lolat(*) *lolatlen) - 90.0
  endif else if (logrid eq  3) then begin	; HadCM3 96*73
    lolongn=lolongn+1 & QExtend=1
    lolonglen=3.75 & lolatlen=2.5
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-180.0
    lolat =findgen(lolatn)  & lolat(*) =(lolat(*) *lolatlen) - 90.0
  endif else if (logrid eq 12) then begin	; half degree
    lolongn=lolongn & QExtend=0
    lolonglen=0.5 & lolatlen=0.5
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-179.5
    lolat =findgen(lolatn)  & lolat(*) =(lolat(*) *lolatlen) - 89.5
  endif else if (logrid eq 5) then begin	; CCCma
    lolongn=lolongn+1 & QExtend=1
    lolonglen=3.75 & lolatlen=3.75
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-180.0
    lolat=fltarr(lolatn)
    lolat(*)=[-87.1591,-83.4789,-79.7770,-76.0702,-72.3616,-68.6520,-64.9419,-61.2316, $
    	      -57.5210,-53.8103,-50.0995,-46.3886,-42.6776,-38.9666,-35.2556,-31.5445, $
    	      -27.8334,-24.1223,-20.4112,-16.7001,-12.9890, -9.2779, -5.5667, -1.8556, $
    	        1.8556,  5.5667,  9.2779, 12.9890, 16.7001, 20.4112, 24.1223, 27.8334, $
    	       31.5445, 35.2556, 38.9666, 42.6776, 46.3886, 50.0995, 53.8103, 57.5210, $
    	       61.2316, 64.9419, 68.6520, 72.3616, 76.0702, 79.7770, 83.4789, 87.1591]
  endif else if (logrid eq 6) then begin	; CSIRO
    lolongn=lolongn+1 & QExtend=1
    lolonglen=5.625 & lolatlen=3.214
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-180.0
    lolat=fltarr(lolatn)
    lolat(*)=[-87.5613,-84.4022,-81.2245,-78.0425,-74.8590,-71.6747,-68.4899,-65.3049, $
    	      -62.1197,-58.9343,-55.7489,-52.5634,-49.3779,-46.1924,-43.0068,-39.8211, $
    	      -36.6355,-33.4498,-30.2642,-27.0785,-23.8928,-20.7071,-17.5214,-14.3357, $
    	      -11.1500, -7.9643, -4.7786, -1.5929,  1.5929,  4.7786,  7.9643, 11.1500, $
    	       14.3357, 17.5214, 20.7071, 23.8928, 27.0785, 30.2642, 33.4498, 36.6355, $
    	       39.8211, 43.0068, 46.1924, 49.3779, 52.5634, 55.7489, 58.9343, 62.1197, $
    	       65.3049, 68.4899, 71.6747, 74.8590, 78.0425, 81.2245, 84.4022, 87.5613]
  endif else if (logrid eq 11) then begin	; PCM or ECHam4
    lolongn=lolongn+1 & QExtend=1
    lolonglen=2.8125 & lolatlen=2.8125
    lolong=findgen(lolongn) & lolong(*)=(lolong(*)*lolonglen)-180.0
    lolat=fltarr(lolatn)
    lolat(*)=[-87.8638,-85.09653,-82.31291,-79.5256,-76.7369,-73.94752, $
    	      -71.15775,-68.36776,-65.57761,-62.78735,-59.99702,-57.20663, $
    	      -54.4162,-51.62573,-48.83524,-46.04473,-43.2542,-40.46365, $
    	      -37.67309,-34.88252,-32.09195,-29.30136,-26.51077,-23.72017,$
    	      -20.92957,-18.13897,-15.34836,-12.55776,-9.767145,-6.976533,$
    	      -4.185921,-1.395307,1.395307,4.185921,6.976533,9.767145,12.55776, $
    	      15.34836,18.13897,20.92957,23.72017,26.51077,29.30136,32.09195,$
    	      34.88252,37.67309,40.46365,43.2542,46.04473,48.83524,51.62573,$
    	      54.4162,57.20663,59.99702,62.78735,65.57761,68.36776,71.15775,$
    	      73.94752,76.7369,79.5256,82.31291,85.09653,87.8638]
  endif else begin
    print, "  > @@@@@ error: no lo grid bounds @@@@@"
  endelse
endif
lodata = fltarr (12,lolongn,lolatn)

SelectModel, higrid, himodelfile, hilongn, hilatn
if (higrid eq 15) then begin			; ATEAM
  hilatmin=34.0 & hilatmax=72.0 & hilongmin=-11.0 & hilongmax=32.0
  hilonglen=(hilongmax-hilongmin)/float(hilongn) & hilatlen=(hilatmax-hilatmin)/float(hilatn)
endif else if (higrid eq 12) then begin		; 0.5deg
  hilatmin=-90.0 & hilatmax=90.0 & hilongmin=-180.0 & hilongmax=180.0
  hilonglen=(hilongmax-hilongmin)/float(hilongn) & hilatlen=(hilatmax-hilatmin)/float(hilatn)
endif else begin
  print, "  > @@@@@ error: no hi grid bounds @@@@@"
endelse
hidata = fltarr (12,hilongn,hilatn)

if (keyword_set(loglomask)) then begin
  getfilebatch,glofiles,Nglofile,callfilter=loglomask
  if (Nglofile ne 12) then print, "  > @@@@@ error: batch does not contain 12 files @@@@@"
  print, "  > Loading from: ", strtrim(loglomask)
  for Xglofile = 0, Nglofile-1 do begin
    LoadGlo, logrid, loslice, glofiles(Xglofile), loinfo, Silent=1
    
    if (QExtend eq 0) then begin
      lodata (Xglofile,*,*) = loslice (*,*)
    endif else begin
      lodata (Xglofile,0:lolongn-2,*) = loslice (*,*)
      lodata (Xglofile,lolongn-1,*) = loslice (0,*)
    endelse
  endfor
endif

gridsize=[hilonglen,hilatlen]
bounds=[hilongmin+(hilonglen/2.0),hilatmin+(hilatlen/2.0),hilongmax-(hilonglen/2.0),hilatmax-(hilatlen/2.0)]
seed=long(lodata(0,0,0)*100.0)
ratio=floor(100000/(lolongn*lolatn)) & if (ratio lt 5) then ratio=5

for Xmonth = 0, 11 do begin
  print, "  > Month ", monthname(Xmonth), " ..."
  pts2=fltarr(long(lolongn)*long(lolatn)*long(ratio),5)			; enter low-res grid into pts2
  xdatum=-1L
  for Xlong = 0, lolongn-1 do begin
    for Xlat= 0, lolatn-1 do begin
      if (lodata(Xmonth,Xlong,Xlat) ne -999.0) then begin
       south=-90.0 & north=90.0
       if (Xlat gt 0)        then south=(lolat(Xlat)+lolat(Xlat-1))/2.0
       if (Xlat lt lolatn-2) then north=(lolat(Xlat)+lolat(Xlat+1))/2.0
        
       for xfake = 0, ratio-1 do begin
        longadd=-999.0 & latadd=-999.0 
        
        while (longadd eq -999 or latadd eq -999) do begin
          longadd = ((randomu(seed)-0.5) * lolonglen) + lolong(Xlong)
          latadd  = ((randomu(seed)-0.5) * lolatlen * 2.0) + lolat(Xlat)
          
          if (longadd lt -180 or longadd gt 180)   then longadd=-999
          if (latadd lt south or latadd gt north) then latadd=-999
	endwhile
	
	if (latadd ge hilatmin and latadd le hilatmax and longadd ge hilongmin and longadd le hilongmax) then begin
          xdatum = xdatum + 1L
          pts2(xdatum,0:2) = [latadd,longadd,lodata(Xmonth,Xlong,Xlat)]
        endif
       endfor
      endif
    endfor
  endfor
  
  pts2=pts2(0L:xdatum,*)
  
  triangulate,pts2(*,1),pts2(*,0),tr,b		; do triangulation
  r=trigrid(pts2(*,1),pts2(*,0),pts2(*,2),tr,gridsize,bounds,xgrid=xgrid,ygrid=ygrid)
  
  hidata(xmonth,*,*) = r(*,*)			; store hi-res grid

  if keyword_set(dumpglo) then begin
    glofile=strip(dumpstem+'.'+monthname(xmonth)+'.glo')
    glotitle=strip('month '+monthname(xmonth))
    SaveGlo,higrid,r,CallFile=glofile,CallTitle=glotitle
  endif  
endfor

if keyword_set(dumpbox) then begin
 print, "  > Saving .box file"
 
 subdirs=str_sep(dumpstem,'/',/trim)
 dim=size(subdirs)
 boxfile=''
 for xsub=1,dim(1)-2 do begin
   boxfile=strtrim(boxfile)+'/'+strtrim(subdirs(xsub))
 endfor
 boxfile=strtrim(boxfile)+'/box.'+strtrim(subdirs(dim(1)-1))
 
 openw, lunSave, boxfile, /get_lun
 for xlong = 0, hilongn-1 do begin
  longflt = ((float(Xlong)+0.5)*hilonglen) + hilongmin
  for xlat = 0, hilatn-1 do begin
    latflt = ((float(Xlat)+0.5)*hilatlen) + hilatmin
    printf,lunSave,latflt,longflt,0.0,  hidata(0,xlong,xlat),hidata(1,xlong,xlat),hidata(2,xlong,xlat), $
    				hidata(3,xlong,xlat),hidata(4,xlong,xlat),hidata(5,xlong,xlat), $
    				hidata(6,xlong,xlat),hidata(7,xlong,xlat),hidata(8,xlong,xlat), $
    				hidata(9,xlong,xlat),hidata(10,xlong,xlat),hidata(11,xlong,xlat), $
    				format="(15f9.3)"
  endfor
 endfor
 free_lun, lunSave
endif

end
