; plothomog.pro
; IDL program written by Tim Mitchell on 07.11.02
; designed to run on the outputs from homogiter.f90

; ******************************************************************************

pro PlotHomog, $
	Filter=Filter, $		; if set, not auto, but plots .txt files
	Suffix=Suffix, $		; variable ".???": set for Filter
	SetDivisor=SetDivisor, $
	NoMetaPlot=NoMetaPlot, $	; remove meta info from plot
	XSizeMulti=XSizeMulti, $	; default = 1.0
	YSizeMulti=YSizeMulti, $	; default = 1.0
	ForceMin=ForceMin, $		; force minimum of scale
	ForceMax=ForceMax, $		; force maximum of scale
	BlackWhite=BlackWhite, $	; force black/white plots
	Silent=Silent

; *************************************** intro

Quiet=0 & if (keyword_set(Silent)) then Quiet=1
Live=1 & if (keyword_set(Filter)) then Live=0

if (Quiet EQ 0) then begin
  print, ""
  print, "  > ***** PlotHomog.pro: plots station time-series *****"
  print, "  > ***** you many minimise this terminal *****"
  print, ""
endif

Black = 0 & Grey = 254 & White = 255
MissVal  = -999.0 & MissCol = White
ScaleSegN = 10 & BatchFileN = 0 & GivenYear = 0 & SuspectBreak = -999
InputText = "" & GivenFile = "" & LastDumpText="standard"
RangeFract = 0.0D & ColSelect  = 0.0D
Int0=0L & Int1=0L & Int2=0L & Int3=0L & Int4=0L & Int5=0L
Int6=0L & Int7=0L & Int8=0L & Int9=0L & Int10=0L & Int11=0L
DumpWMO=0L & DumpName="" & DumpCty="" & DumpYearN=0 & DumpText="" & DumpTitle=""
MemYearAD0=-999 & MemYearAD1=-999 & QFound=-1 & DumpPlot=0

Months = [0.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5]
XLabel = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

if (keyword_set(NoMetaPlot)) then begin
  PlotCorners  = [0.10,0.05,0.65,0.95]
  ScaleCorners = [0.68,0.05,0.78,0.95]
  HomogCorners = [0.80,0.05,0.95,0.95]
endif else begin
  PlotCorners  = [0.10,0.12,0.65,0.88]
  ScaleCorners = [0.85,0.08,0.95,0.88]
  HomogCorners = [0.68,0.12,0.83,0.88]
endelse

XPixels=16 & YPixels=12
if (keyword_set(XSizeMulti)) then XPixels = XPixels * XSizeMulti
if (keyword_set(YSizeMulti)) then YPixels = YPixels * YSizeMulti

; *************************************** specify variable

if (Live EQ 1) then begin
  spawn, 'rm /cru/scratch2/f709762/f90toidl.pipe', StOut
  spawn, 'mkfifo -m a=rw /cru/scratch2/f709762/f90toidl.pipe'
  spawn, 'tail < /cru/scratch2/f709762/f90toidl.pipe', F90info
  VariableSuffix = "" & VariableSuffix = strtrim(F90info(0),2)
  SaveDir = '/cru/tyn1/f014/scratch/'
endif else begin
  GetFileBatch, Batch, BatchN, CallFilter=Filter
  print, "  > Files found total: ", BatchN
  
  DumpFile=Batch(0)
  LastSlash=strpos(DumpFile,'/',/reverse_search)	; crua6 version
;  LastSlash=rstrpos(DumpFile,'/')			; crua4 version
  SaveDir=strmid(DumpFile,0,(LastSlash+1))
  XBatch=-1
  
  if (keyword_set(Suffix)) then begin
    VariableSuffix=Suffix
  endif else begin
    VariableSuffix = ""
    print, "  > Enter the variable suffix ('.???'): "
    read, VariableSuffix
  endelse
endelse

if            (VariableSuffix EQ ".pre") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=1
endif else if (VariableSuffix EQ ".tmp") then begin
  TmpPre=0 & Divisor=10 & LimitLo=MissVal & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".dtr") then begin
  TmpPre=0 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".cld") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=100.0 & DiffRatio=0
endif else if (VariableSuffix EQ ".spc") then begin
  TmpPre=0 & Divisor=10 & LimitLo=0.0 & LimitHi=100.0 & DiffRatio=0
endif else if (VariableSuffix EQ ".wet") then begin
  TmpPre=1 & Divisor=100 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=1
endif else if (VariableSuffix EQ ".rhm") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".vap") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else begin
  print, "  > @@@@@ ERROR: variable unrecognised @@@@@"
endelse

AbsScale=61 & AnoScale=62 & StDevRange=10
if (TmpPre EQ 1) then begin
  AbsScale=63 & AnoScale=64 & StDevRange=5
endif

DumpMissVal = -9999.0

; *************************************** main station loop

DumpFile="" & CurrentStn=0L

while (DumpFile NE "end") do begin			; get file path
  if (Live EQ 1) then begin
    spawn, 'tail < /cru/scratch2/f709762/f90toidl.pipe', F90info	
    DumpFile = strtrim(F90info(0),2)
  endif else begin
    XBatch=XBatch+1 & DumpFile='end'
    if (XBatch LT BatchN) then DumpFile=Batch(XBatch)
  endelse
  
  if (Quiet EQ 0) then print, "file  = ", strtrim(DumpFile,2)
  
  if (strtrim(DumpFile,2) NE 'end') then begin
    GrabDumpData,DumpFile,DumpData,DumpHomog,DumpYearAD,DumpWMO,DumpName,DumpCty, $
    		DumpText,DumpPlot,DumpTitle
    
    if (DiffRatio EQ 1 AND strmid(DumpText,0,4) NE 'Abso') then begin
      Multiply = 100.0
    endif else begin
      Multiply = Divisor
    endelse
    
    DumpData(*,*) = DumpData(*,*) / Multiply		; convert to *1.0 values
    DumpHomog(*)  = DumpHomog(*)  / Multiply

;    LastSlash   = strpos(DumpFile,"/",/Reverse_Search)	; crua6 version
    LastSlash   = rstrpos(DumpFile,"/")			; crua4 version
    FirstDigit  = LastSlash + 1
    AfterEnd    = strpos(DumpFile,".",FirstDigit)
    StnCodeText = strmid(DumpFile,FirstDigit,(AfterEnd-FirstDigit))
    StnCode     = long(StnCodeText)
    
    if (StnCode NE CurrentStn) then begin			; get beg/end years
        GrabBegEnd,DumpData,(DumpMissVal/Multiply),XYear0,XYear1
        PlotYearAD0=DumpYearAD(XYear0) & PlotYearAD1=DumpYearAD(XYear1)
        if (Quiet EQ 0) then print, $
        	"NEW STATION DETECTED: ",PlotYearAD0,PlotYearAD1
        CurrentStn = StnCode
    endif

    HomogMissings = where(DumpHomog EQ (-999.0/Multiply), Count) ; correct annual
    if (Count GT 0) then DumpHomog [HomogMissings] = !Values.F_NaN
    
    Missings = where (DumpData EQ (DumpMissVal/Multiply), Count) ; correct monthly
    if (Count GT 0) then DumpData [Missings] = !Values.F_NaN
    
    Reformed = reform(DumpData(*,XYear0:XYear1))		; shrink to desired data
    Years = DumpYearAD(XYear0:XYear1)
    
    HomogMax= max(DumpHomog,/nan) & HomogMaxInt=ceil(HomogMax)
    HomogColors=DumpHomog & HomogColors(*)=Black
    
    if  	  (strmid(DumpText,0,4) EQ 'Diff' OR $
    		   strmid(DumpText,0,4) EQ 'Step' OR $
    		   strmid(DumpText,0,4) EQ 'Anom') then begin	; get data range
      loadanyct, AnoScale
      if (strmid(DumpText,4,4) EQ 'Orig') then begin
        if (DiffRatio EQ 0) then begin
          Moments = moment(Reformed,/nan)
          DataMin = 0-(2.0*sqrt(Moments(1))) & DataMax = 0+(2.0*sqrt(Moments(1)))
        endif else begin
          Logged = alog10(Reformed)
          LoLog = where (Logged LT 0.0, LoCount)
          HiLog = where (Logged GT 0.0, HiCount)
          DataMin=0.0 & DataMax=0.0
          if (LoCount GT 1) then begin
            LoMom = moment(Logged(LoLog),/nan)
            DataMin = LoMom(0)-(2.0*sqrt(LoMom(1)))
          endif
          if (HiCount GT 1) then begin
            HiMom = moment(Logged(HiLog),/nan)
            DataMax = HiMom(0)+(2.0*sqrt(HiMom(1)))
          endif
          if ((0.0-DataMin) LT DataMax) then begin
            DataMin = 0.0-DataMax
          endif else begin
            DataMax = 0.0-DataMin
          endelse
          if (DataMax LT 0.01) then begin
            DataMin = -0.01 & DataMax = 0.01
          endif
          DataMin = 10.0 ^ DataMin & DataMax = 10.0 ^ DataMax
        endelse 
        
        if (strmid(DumpText,0,4) EQ 'Step') then begin
          StepDataMin=DataMin & StepDataMax=DataMax
        endif else begin
          DiffDataMin=DataMin & DiffDataMax=DataMax
        endelse
      endif else if (strmid(DumpText,0,4) EQ 'Step') then begin
        DataMin=StepDataMin & DataMax=StepDataMax
      endif else begin
        DataMin=DiffDataMin & DataMax=DiffDataMax
      endelse
    endif else if (strmid(DumpText,0,4) EQ 'Abso') then begin
      loadanyct, AbsScale
      if (strmid(DumpText,4,4) EQ 'Orig') then begin
        Moments = moment(Reformed,/nan)			; crua6 version
;        RefValid = where(Reformed NE !VALUES.F_NAN)		; crua4 version
;        Moments = moment(Reformed(RefValid))			; crua4 version
        
        DataMin = Moments(0)-(2.0*sqrt(Moments(1)))
        DataMax = Moments(0)+(2.0*sqrt(Moments(1)))
        if (LimitLo NE MissVal AND DataMin LT LimitLo) then DataMin=LimitLo
        if (LimitHi NE MissVal AND DataMax GT LimitHi) then DataMax=LimitHi
        AbsoDataMin=DataMin & AbsoDataMax=DataMax
      endif else begin
        DataMin=AbsoDataMin & DataMax=AbsoDataMax
      endelse
    endif
    
    PlotTitle = strtrim(DumpName,2) + ' (' + strtrim(DumpCty,2) + ', ' + $
    				strtrim(string(DumpWMO),2) + ')'
    StrLoc = strpos(DumpFile,'/',/reverse_search)		; crua6 version
;    StrLoc = rstrpos(DumpFile,'/')				; crua4 version
    StrLen = strlen(DumpFile)
    StrSub = strmid(DumpFile,(StrLoc+1),(StrLen-StrLoc-4))
    SavePath = strtrim(SaveDir,2) + StrSub + 'eps'
    
    YearADFlt = float(Years)/10.0
    YearADInt = round(YearADFlt)
    YTickVal  = where (float(YearADInt) EQ YearADFlt, YTickCount)    
    YearADInt = YearADInt * 10
    
    if (ytickcount eq 0) then begin	; no decade data range, do start/end instead
    	YearADInt = Years
    	YearADIntDim = size (YearADInt)
    	ytickcount = 2
    	ytickval = intarr(ytickcount)
    	ytickval(*) = [0,YearADIntDim[1]-1]
    endif
    
    NoNameY=strarr(YTickCount) & NoNameY(*)=" "
    
    if (strmid(DumpText,0,4) EQ 'Anom' OR strmid(DumpText,0,4) EQ 'Homo') $
    		then loadanyct, AnoScale
    
    if (keyword_set(ForceMin)) then DataMin = ForceMin
    if (keyword_set(ForceMax)) then DataMax = ForceMax

    ContourN=21 & if keyword_set(BlackWhite) then ContourN=6
    
    if (DiffRatio EQ 0) then begin
      GetContours, [DataMin,DataMax], [1,253], Contours, ContourColors, ContourN
    endif else begin
      GetContours, [DataMin,DataMax], [1,253], Contours, ContourColors, ContourN,/Log
    endelse
    ContoursSparse = fltarr(5)
    for XSparse = 0, 4 do begin
      ContoursSparse(XSparse) = DataMin + (XSparse * ((DataMax-DataMin) / 4))
    endfor
    
    TrimToScale, Reformed, TrimSlice, [DataMin,DataMax], /SinglePrec
    
    Set_Plot, 'ps', /copy
    
    if keyword_set(BlackWhite) then begin
      device, filename=SavePath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels, $
      		/encapsulated
    endif else begin
      device, filename=SavePath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels, $
      		/Color,/encapsulated
    endelse
    
    if (keyword_set(NoMetaPlot)) then begin
      plot, [PlotYearAD0,PlotYearAD1], xrange=[0.5,11.5], yrange=[PlotYearAD0,PlotYearAD1], position=PlotCorners, $
    	ticklen=1.0,color=Black,/noerase,/nodata,charsize=0.8, $
    	xstyle=1, xticks=11, xthick=1, xtickv=months, xtickname=xlabel, font=5,  $
    	ystyle=1, yticks=YTickCount-1, ythick=1, ytickv=YearADInt[YTickVal]
    endif else begin
      plot, [PlotYearAD0,PlotYearAD1], xrange=[0.5,11.5], yrange=[PlotYearAD0,PlotYearAD1], position=PlotCorners, $
    	ticklen=1.0,color=Black,/noerase,/nodata,subtitle=PlotTitle,title=strtrim(DumpTitle),charsize=0.8, $
    	xstyle=1, xticks=11, xthick=1, xtickv=months, xtickname=xlabel, font=5,  $
    	ystyle=1, yticks=YTickCount-1, ythick=1, ytickv=YearADInt[YTickVal]
    endelse
    
    if keyword_set(BlackWhite) then begin
      contour, TrimSlice, Months, Years, levels=Contours,/overplot,/noerase
    endif else begin
      contour, TrimSlice, Months, Years, levels=Contours, $
    	c_colors=ContourColors, /cell_fill, /overplot,/noerase
    endelse
    
    if (keyword_set(NoMetaPlot)) then begin
      plot, [PlotYearAD0,PlotYearAD1], xrange=[0.5,11.5], yrange=[PlotYearAD0,PlotYearAD1], position=PlotCorners, $
    	ticklen=1.0,color=Black,/noerase,/nodata,charsize=0.8, $
    	xstyle=1, xticks=11, xthick=1, xtickv=months, xtickname=xlabel, font=5, $
    	ystyle=1, yticks=YTickCount-1, ythick=1, ytickv=YearADInt[YTickVal]
    endif else begin
      plot, [PlotYearAD0,PlotYearAD1], xrange=[0.5,11.5], yrange=[PlotYearAD0,PlotYearAD1], position=PlotCorners, $
    	ticklen=1.0,color=Black,/noerase,/nodata,subtitle=PlotTitle,title=strtrim(DumpTitle),charsize=0.8, $
    	xstyle=1, xticks=11, xthick=1, xtickv=months, xtickname=xlabel, font=5, $
    	ystyle=1, yticks=YTickCount-1, ythick=1, ytickv=YearADInt[YTickVal]
    endelse
    
    if keyword_set(BlackWhite) then begin
    	; no scale necessary
    endif else if (strmid(DumpText,0,4) EQ 'Abso' OR DiffRatio EQ 0) then begin
      DrawConScale,ScaleCorners,Contours,ContourColors,ContoursSparse, $
      			"(f7.2)",0.8,1,"",XPixels,YPixels,0
    endif else begin
      DrawConScale,ScaleCorners,Contours,ContourColors,ContoursSparse, $
      			"(f7.2)",0.8,1,"",XPixels,YPixels,0,/log
    endelse
    
    plot, DumpHomog,DumpYearAD,PSym=0,yrange=[PlotYearAD0,PlotYearAD1], $
    	position=HomogCorners,charsize=0.8,font=5,/noerase,ticklen=1.0,thick=5, $
    	xthick=1,ystyle=1,yticks=YTickCount-1,ythick=1,ytickv=YearADInt[YTickVal], $
    	ytickname=NoNameY,xticks=3,color=Grey,/nodata
    oplot, DumpHomog,DumpYearAD,PSym=0,thick=3,color=Black
    
    if (strmid(DumpText,0,4) NE 'Abso') then begin
      if (DiffRatio EQ 0) then begin
        Baseline=0.0 
      endif else begin
        Baseline=1.0
      endelse
      
      plots,[Baseline,Baseline],[PlotYearAD0,PlotYearAD1],linestyle=1,color=Black
    endif
    
;    print, "winddown..."	 ; @@@@@@@@@@
    device, /close
    set_plot, 'X'	

    if (strmid(DumpText,0,4) EQ 'Anom' OR strmid(DumpText,0,4) EQ 'Homo') $
    		then loadanyct, AbsScale
    
    if (Quiet EQ 0) then print, "save  = ", strtrim(SavePath,2)
    GVcommand = 'ghostview ' + strtrim(SavePath,2) + ' &'
    if (DumpPlot NE 2 AND Live EQ 1) then spawn, GVcommand, GVoutput
;    print, "finished..."	 ; @@@@@@@@@@
  endif
endwhile

; *************************************** end

if (Quiet EQ 0) then print, ""

if (Live EQ 1) then spawn, 'rm /cru/scratch2/f709762/f90toidl.pipe'

end 
