; plotscatter.pro

MissVal = -999.0

DateTime  = systime ()
DateStamp = strmid(DateTime,4,7) + strmid(DateTime,20,4)

loadanyct, 33
Black=0 & Grey=254 & White=255

NInfo = 20
InfoText = strarr(NInfo)
InfoText = ['The values are the changes between','the end of the 20th (1961-90)',$
	    'and 21st (2070-99) centuries','from 9 climate models',$
	    'reviewed by the IPCC (2001).','',$
	    'The 4 plots illustrate 2 seasons','(DJF=Dec-Feb, JJA=Jun-Aug)',$
	    'and 2 emissions scenarios','(A2,B2 from IPCC SRES).','',$
	    'The data were interpolated onto','a common grid by Dr. R. Jones',$
	    '(Hadley Centre); they were','regridded and aggregated into',$
	    'countries by Dr. T. D. Mitchell.','','Mitchell TD, Hulme M, New M (2002)',$
	    'Climate data for political areas','Area 34:109-112']

ScenSeasText = strarr(4)
ScenSeasText[*] = ['a2.djf','a2.jja','b2.djf','b2.jja']

ScenSeasCaps = strarr(4)
ScenSeasCaps[*] = ['A2 DJF','A2 JJA','B2 DJF','B2 JJA']

AxisXLabel = "temperature change (degC)"
GiveSymbol, AxisXLabel
AxisYLabel = "precipitation change (%)"

ModelText = strarr(9)
ModelText [*] = ['CCCma','CSIRO','CSM','DMI','GFDL','MRI2','NIES','PCM','UKMO']

GCMText = strarr(9)
GCMText [*] = ['CGCM2','CSIRO mk 2','CSM 1.3','ECHam4','GFDL R15 b','MRI2','CCSR/NIES 2','DOE PCM','HadCM3']

CtyText = strarr(9)
CtyText [*] = ['Canada','Australia','USA','Germany','USA','Japan','Japan','USA','UK']

ModelColor = intarr(9)
ModelColor [*] = [0,30,60,90,120,150,180,210,240]

Exes = intarr(5) & Wyes = intarr(5)
Exes(*) = [-1,0,1,0,-1] & Wyes(*) = [0,1,0,-1,0]

SingleTemp=fltarr(1) & SinglePrec=fltarr(1)

RefFile='/cru/u2/f709762/goglo/ref/half-degree-cty-v3.ref'
LoadRef, 12, 720, 360, MapIDLReg, RegSize, RegName, RegColour, NReg, CallFile=RefFile
for XReg = 0, (NReg-1) do begin  
  while (strpos(RegName(XReg),'.') GT -1) do begin
    DotPlace=strpos(RegName(XReg),'.')
    RegText=RegName(XReg) & RegText(DotPlace:DotPlace)=" " & RegName(XReg)=RegText
  endwhile
endfor
RegNameCompress = strcompress(RegName,/remove_all)

RegName=strtrim(RegName,2)
RegNameSort=sort(RegName)
print, "  > Dumping html code to file ..."
TxtFilePath='/cru/tyn1/f709762/tyn_cy_3.0/v3.01/cty-v3.txt'
openw, lunTxt, TxtFilePath, /get_lun, error=OpenStatus
for XReg=0,(NReg-1) do begin
  printf,lunTxt,"<tr><td><font face='Verdana'><font size=-2>",RegName(RegNameSort(XReg)),"</font></font></td>",format="(3a)"
  printf,lunTxt,"<td><font face='Verdana'><font size=-2><a href='http://www.cru.uea.ac.uk/~timm/climate/scatter/cty-v3.",RegNameCompress(RegNameSort(XReg)),".pdf'>graphic</a></font></font></td>",format="(3a)"
  printf,lunTxt,"<td><font face='Verdana'><font size=-2><a href='http://www.cru.uea.ac.uk/~timm/climate/scatter/cty-v3.",RegNameCompress(RegNameSort(XReg)),".txt'>data</a></font></font></td></tr>",format="(3a)"
endfor
free_lun, lunTxt

TempData = fltarr(4,9,NReg) & PrecData = fltarr(4,9,NReg)
TempData(*,*,*) = MissVal & PrecData(*,*,*) = MissVal
							; get region info
for XScenSeas = 0, 3 do begin				; load all data
  for XModel = 0, 8 do begin
    print, "  > Loading: ", ScenSeasCaps[XScenSeas], " ", ModelText[XModel]
    
    TempFile='/cru/mikeh1/f709762/ukcip/rjones/_05deg/cty-v3.' 
    TempFile=TempFile + ModelText[XModel] + '.' + ScenSeasText[XScenSeas] + '.temp.glo'
    LoadGlo, 12, TempSlice, TempFile, FileInfo, Silent=1
    
    PrecFile='/cru/mikeh1/f709762/ukcip/rjones/_05deg/cty-v3.' 
    PrecFile=PrecFile + ModelText[XModel] + '.' + ScenSeasText[XScenSeas] + '.ppt-pc.glo'
    LoadGlo, 12, PrecSlice, PrecFile, FileInfo, Silent=1
    
    for XLon = 0, 719 do begin
      for XLat = 0, 359 do begin
        if (MapIDLReg(XLon,XLat) NE -999) then begin
        	TempData(XScenSeas,XModel,MapIDLReg(XLon,XLat))=TempSlice(XLon,XLat)
        	PrecData(XScenSeas,XModel,MapIDLReg(XLon,XLat))=PrecSlice(XLon,XLat)
        endif
      endfor
    endfor
  endfor
endfor
    
Missing = where(TempData EQ -999.0, Count) & if (Count GT 0) then TempData(Missing) = !Values.F_NaN
Missing = where(PrecData EQ -999.0, Count) & if (Count GT 0) then PrecData(Missing) = !Values.F_NaN

for XScenSeas = 0, 3 do begin				; dump to all-region file
  for XVari = 0, 1 do begin
    TxtPath='/cru/mikeh1/f709762/ukcip/rjones/_05deg/cty-v3.' + ScenSeasText[XScenSeas]
    if (XVari EQ 0) then begin
    	TxtPath=TxtPath+'.temp.txt' 
    endif else begin
    	TxtPath=TxtPath+'.prec.txt'
    endelse
    openw, lunTxt, TxtPath, /get_lun, error=OpenStatus
    if (XVari EQ 0) then begin
      printf,lunTxt, strtrim(ScenSeasCaps[XScenSeas],2), $
    			' temperature changes in the 21st century',format="(2a)"
    endif else begin
      printf,lunTxt, strtrim(ScenSeasCaps[XScenSeas],2), $
    			' precipitation changes in the 21st century',format="(2a)"
    endelse
    printf,lunTxt,'Dr.T.D.Mitchell, Tyndall Centre (www.tyndall.ac.uk), ',DateStamp,format="(2a)"
    printf,lunTxt,'',format="(a)"
    printf,lunTxt,'The data are from 9 state-of-the-art GCMs reviewed by the IPCC (2001).',format="(a)"
    printf,lunTxt,'The values are the changes between 1961-90 and 2070-99.',format="(a)"
    if (XVari EQ 0) then begin
      printf,lunTxt,'The variable is temperature (T,degC).',format="(a)"
    endif else begin
      printf,lunTxt,'The variable is precipitation (P,%).',format="(a)"
    endelse    
    printf,lunTxt,'The SRES emissions scenario and season are: ',strtrim(ScenSeasCaps[XScenSeas],2),format="(2a)"
    printf,lunTxt,'Dr. Richard Jones (Hadley Centre) interpolated the original GCM data',format="(a)"
    printf,lunTxt,'onto a common grid (144*73). Dr.T.D.Mitchell regridded these data (720*360)',format="(a)"
    printf,lunTxt,'and aggregated the land grid-boxes into countries.',format="(a)"
    printf,lunTxt,'',format="(a)"
    printf,lunTxt,'These data may be freely used for non-commerical purposes on condition that',format="(a)"
    printf,lunTxt,'the following source is acknowledged wherever the data are used:',format="(a)"
    printf,lunTxt,'Mitchell,T.D., Hulme,M., and New,M., 2002: Climate data for political areas. Area 34:109-112',format="(a)"
    printf,lunTxt,'',format="(a)"
    printf,lunTxt,'COUNTRY',ModelText(*),format="(a20,9a9)"
    for XReg = 0, (NReg-1) do begin
      if (XVari EQ 0) then begin
        printf,lunTxt,RegName(RegNameSort(XReg)),TempData(XScenSeas,*,RegNameSort(XReg)), $
      			format="(a20,9f9.2)"
      endif else begin
        printf,lunTxt,RegName(RegNameSort(XReg)),PrecData(XScenSeas,*,RegNameSort(XReg)), $
      			format="(a20,9f9.2)"
      endelse
    endfor
    free_lun, lunTxt
  endfor
endfor

ScatterTemp = fltarr(9) & ScatterPrec = fltarr(9)
XPixels=20 & YPixels=16
PlotCorners=fltarr(4,4)
for XRow = 0,1 do begin
  for XCol = 0,1 do begin
    XPlot=(XRow*2)+XCol
    PlotCorners(XPlot,1) = 0.50-(XRow*0.40) & PlotCorners(XPlot,3) = 0.75-(XRow*0.40)
    PlotCorners(XPlot,0) = 0.10+(XCol*0.33) & PlotCorners(XPlot,2) = 0.35+(XCol*0.33)
  endfor
endfor

print, "  > Plotting each region to .eps ..."
for XReg = 0, (NReg-1) do begin
  TxtPath='/cru/mikeh1/f709762/ukcip/rjones/_05deg/cty-v3.' + RegNameCompress(XReg) + '.txt'
  openw, lunTxt, TxtPath, /get_lun, error=OpenStatus
  printf,lunTxt,strtrim(RegName(XReg),2),': climate changes in the 21st century',format="(2a)"
  printf,lunTxt,'Dr.T.D.Mitchell, Tyndall Centre (www.tyndall.ac.uk), ',DateStamp,format="(2a)"
  printf,lunTxt,'',format="(a)"
  printf,lunTxt,'The data are from 9 state-of-the-art GCMs reviewed by the IPCC (2001).',format="(a)"
  printf,lunTxt,'The values are the changes between 1961-90 and 2070-99.',format="(a)"
  printf,lunTxt,'The two variables are temperature (T,degC) and precipitation (P,%).',format="(a)"
  printf,lunTxt,'There are 2 SRES emissions scenarios (A2,B2) and 2 seasons (DJF,JJA).',format="(a)"
  printf,lunTxt,'Dr. Richard Jones (Hadley Centre) interpolated the original GCM data',format="(a)"
  printf,lunTxt,'onto a common grid (144*73). Dr.T.D.Mitchell regridded these data (720*360)',format="(a)"
  printf,lunTxt,'and aggregated the land grid-boxes into countries.',format="(a)"
  printf,lunTxt,'',format="(a)"
  printf,lunTxt,'These data may be freely used for non-commerical purposes on condition that',format="(a)"
  printf,lunTxt,'the following source is acknowledged wherever the data are used:',format="(a)"
  printf,lunTxt,'Mitchell,T.D., Hulme,M., and New,M., 2002: Climate data for political areas. Area 34:109-112',format="(a)"
  printf,lunTxt,'',format="(a)"
  printf,lunTxt,"MODEL"," T-A2-DJF"," T-A2-JJA"," T-B2-DJF"," T-B2-JJA",$
  	" P-A2-DJF"," P-A2-JJA"," P-B2-DJF"," P-B2-JJA",format="(a12,8a9)"
  for XModel = 0, 8 do begin
    printf,lunTxt,GCMText(XModel),TempData(0,XModel,XReg),TempData(1,XModel,XReg),$
    	TempData(2,XModel,XReg),TempData(3,XModel,XReg),PrecData(0,XModel,XReg),$
    	PrecData(1,XModel,XReg),PrecData(2,XModel,XReg),PrecData(3,XModel,XReg),format="(a12,8f9.2)"
  endfor
  free_lun, lunTxt
  
  EPSPath='/cru/mikeh1/f709762/ukcip/rjones/_05deg/cty-v3.' + RegNameCompress(XReg) + '.eps'
  Set_Plot, 'ps', /copy
  device, filename=EPSPath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels, /Color, /Encapsulated
    
  read_jpeg, '/cru/u2/f709762/goglo/ref/tyn-logo-torok.jpg', Logo, LogoCT, colors=256, dither=1, /two_pass_quantize
  tvlct, Red,Green,Blue, /get						; get old colors
  tvlct, LogoCT(*,0), LogoCT(*,1), LogoCT(*,2)
  tv, Logo, 0.04,0.89,xsize=0.834*0.3*(7.0/9.0),ysize=0.184*0.3,/normal
  tvlct, Red,Green,Blue							; restore old colors

  xyouts,0.95,0.93,'Dr. Timothy D. Mitchell',/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.95,0.91,DateStamp,/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.95,0.89,'www.tyndall.ac.uk',/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.50,0.93,strtrim(RegName(XReg),2),alignment=0.5,charsize=2,charthick=2,font=5,/normal
  xyouts,0.50,0.89,'21st century climate changes',alignment=0.5,charsize=1,charthick=1,font=5,/normal
  
  MaxTemp=max(TempData(*,*,XReg)) & MinTemp=min(TempData(*,*,XReg))
  MaxPrec=max(PrecData(*,*,XReg)) & MinPrec=min(PrecData(*,*,XReg))
  if (MaxTemp LT  1) then MaxTemp=1 
  if (MinTemp GT -1) then MinTemp=-1
  if (MaxPrec LT  5) then MaxPrec=5 
  if (MinPrec GT -5) then MinPrec=-5
  
  for XScenSeas = 0, 3 do begin				; plot all data
    for XModel = 0, 8 do begin
      ScatterTemp[XModel] = TempData[XScenSeas,XModel,XReg]
      ScatterPrec[XModel] = PrecData[XScenSeas,XModel,XReg]
    endfor
        
    plot, ScatterTemp, ScatterPrec, $				; to get good data limits
  	Background=White,Color=Black,$				; colour		
  	Title=ScenSeasCaps(XScenSeas),$				; plot title
  	XTitle=AxisXLabel ,$					; x axis title
  	YTitle=AxisYLabel,$					; y axis title  	
  	XTickLen=1.0,YTickLen=1.0,XGridStyle=1,YGridStyle=1, $  ; grid
  	XRange=[MinTemp,MaxTemp],YRange=[MinPrec,MaxPrec],$	; axis limits
	font=5,charsize=1.0,xcharsize=0.7,ycharsize=0.7, $	; character sizes
  	/NoData,position=PlotCorners[XScenSeas,*],/NoErase
    
    for XModel = 0, 8 do begin					; plot data
      usersym,Exes,Wyes,/fill,color=ModelColor[XModel]
      SingleTemp[0]=ScatterTemp[XModel] & SinglePrec[0]=ScatterPrec[XModel]
      oplot, SingleTemp,SinglePrec, psym=-8
    endfor
  
    plots,!X.CRange,[0,0],linestyle=0,thick=2,color=Black,/data	; plot heavy axes
    plots,[0,0],!Y.CRange,linestyle=0,thick=2,color=Black,/data
  endfor
  
  xyouts,0.73,0.80,'KEY to models',/normal,alignment=0,charsize=1,charthick=1,font=5  
  for XModel = 0, 8 do begin					; key
    usersym,Exes,Wyes,/fill,color=ModelColor[XModel]
    plots, 0.74,0.80-((XModel+1)*0.03), psym=-8, /normal
    xyouts, 0.76,0.795-((XModel+1)*0.03), GCMText[XModel],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
    xyouts, 0.88,0.795-((XModel+1)*0.03), CtyText[XModel],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
  endfor
  
  xyouts,0.73,0.46,'INFORMATION',/normal,alignment=0,charsize=1,charthick=1,font=5  
  for XInfo = 0, (NInfo-1) do begin
    xyouts, 0.73,0.44-((XInfo+1)*0.02), InfoText[XInfo],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
  endfor
  
  device, /close
  set_plot, 'X'
endfor

end
