print, "  > Plot to screen (=21) or .eps (=22) ? "
read, Choice

print, "  > Plot first (=1) or all four (=4) ? "
read, PlotN

if (Choice EQ 21) then begin
  if (!D.Window EQ -1) then window, /free, xsize=(3*PlotSizeFactor), ysize=(2*PlotSizeFactor), $
  		xpos=(1000-(3*PlotSizeFactor)), title="box plot"
  set_plot, 'X'	
endif else begin
  PSPath = ""
  print, "  > Enter the filepath of the .eps file: "
  read, PSPath

  Set_Plot, 'ps', /copy
  device, filename=PSPath, bits_per_pixel=8, /Color, /encapsulated
endelse

PlotCorners = fltarr (4,4)

if (PlotN EQ 1) then begin
    PlotCorners (0,*) = [0.02,0.02,0.88,0.98]
endif else begin
  if (PlotN EQ 4) then begin
    PlotCorners (0,*) = [0.02,0.52,0.38,0.98]
    PlotCorners (1,*) = [0.52,0.52,0.88,0.98]
    PlotCorners (2,*) = [0.02,0.02,0.38,0.48]
    PlotCorners (3,*) = [0.52,0.02,0.88,0.48]
  endif else begin
    print, "  > ##### ERROR: Funny PlotN #####"
  endelse
endelse

for XPlot = 0, (PlotN-1) do begin
 if (SetGlo(XPlot) NE MissVal) then begin
  if (SetScale(XPlot) NE MissVal) then begin
   if (SetView(XPlot) NE MissVal) then begin
    
    if (SetScale[XPlot] NE CurrentScale OR XPlot EQ 0) then begin
     
     MyColTab = ScaleColTab (SetScale[XPlot])
     LoadAnyCT, MyColTab

     GetScaleVectors,reform(ScaleLimits(SetScale[XPlot],*)),ScaleLevels,ScaleColors,ScaleSeg[SetScale[XPlot]]
     GetContours,reform(ScaleLimits(SetScale[XPlot],*)),Contours,ContourColors,ScaleSeg[SetScale[XPlot]]
     ArraySize = size(Contours)
     ContourN  = ArraySize(1)
     
     CurrentScale = SetScale[XPlot]
     
    endif
    
    PlotImageSlice = fltarr (ModelLongN,ModelLatN)
    PlotImageSlice = reform (Slice(SetGlo[XPlot],*,*))
    
    for XLong = 0, (ModelLongN-1) do begin
      for XLat = 0, (ModelLatN-1) do begin
        if (PlotImageSlice(XLong,XLat) NE MissVal) then begin
          if (PlotImageSlice(XLong,XLat) LT Contours(0)) then begin
              PlotImageSlice(XLong,XLat) = Contours(0)
          endif else begin
            if (PlotImageSlice(XLong,XLat) GT Contours(ContourN-1)) then begin
              PlotImageSlice(XLong,XLat) = Contours(ContourN-1)
            endif
          endelse 
        endif else begin
              PlotImageSlice(XLong,XLat) = !Values.F_NaN
        endelse
      endfor
    endfor
    
    LonLen = (ImageLongMax-ImageLongMin) / ModelLongN
    LatLen = (ImageLatMax -ImageLatMin ) / ModelLatN 
    
    Long = (findgen (ModelLongN) * LonLen)  + ImageLongMin
    Lati = (findgen (ModelLatN)  * LatLen)  + ImageLatMin

    contour, PlotImageSlice, Long, Lati, levels=Contours, c_colors=ContourColors, /cell_fill, $
    		xrange=[ImageLongMin,(ImageLongMax-(LonLen*3))], $
    		yrange=[ImageLatMin, (ImageLatMax)], $
    		ystyle=5, xstyle=5, position=reform(PlotCorners(XPlot,*)), /noerase
    
    DrawScale, PlotN=PlotN, ThisPlot=XPlot, DataEnds=[0.0,150.0], ColEnds=[253.0,67.0], BandN=15
    
    print, "  > Plot, scale, region, .glo: ", XPlot, " ", ScaleName[SetScale[XPlot]], " ", $
    			ViewName[SetView[XPlot]], " ", SetGlo[XPlot], $
    			format="(A30,I3,A1,A10,A1,A10,A1,I3)"
    
   endif else begin
    print, "  > No view assigned to plot:  ", XPlot, format="(A30,I3)"
   endelse

  endif else begin
    print, "  > No scale assigned to plot: ", XPlot, format="(A30,I3)"
  endelse

 endif else begin
    print, "  > No .glo assigned to plot:  ", XPlot, format="(A30,I3)"
 endelse

endfor

if (Choice EQ 22) then 	device, /close

set_plot, 'X'	

end

