pro bin2ascii_tdm,binfl,ascfl,limit,blank=blank,compress=compress,zip=zip,gzip=gzip,$
 no_ant=no_ant,ddc=ddc,mmperday=mmperday,gs=gs
if n_params() lt 1 then begin
 print,'bin2ascii,binfl,ascfl,limit,blank=blank,compress=compress,zip=zip,'
 print,'gzip=gzip,no_ant=no_ant,ddc=ddc,mmperday=mmperday,gs=gs'
 return
endif
; converts a 0.5 degree binary grid to 0.5 degree ascii grid
if keyword_set(gs) eq 0 then gs=0.5

rdbin,grid,binfl,gridsize=gs,/quiet
if keyword_set(mmperday) then begin
 for im=0,11 do begin
  temp=grid(*,*,im)
  n=where(temp ne -9999)
  temp(n)=round(10*float(temp(n))/days(im))
  grid(*,*,im)=temp
 endfor
endif
;help,grid
close,20
openw,20,ascfl
print,binfl
print,ascfl
dxy=360.0/n_elements(grid(*,0,0))
defxyz,lon,lat,dxy
help,lon,lat
print,rnge(lon),rnge(lat)
if keyword_set(ddc) then no_ant=1
if keyword_set(no_ant) then blank=[-90,-180,-60.1,180]
if n_elements(blank) eq 4 then begin
 nlon=where(lon ge blank(1) and lon le blank(3),nnlon)
 nlat=where(lat ge blank(0) and lat le blank(2),nnlat)
 if nnlon gt 0 and nnlat gt 0 then begin
  rlon=rnge(nlon)
  rlat=rnge(nlat)
  grid(rlon(0):rlon(1),rlat(0):rlat(1),*)=-9999
 endif
endif
if keyword_set(limit) eq 0 then limit=glimit(/all)
nlon=where(lon ge limit(1) and lon le limit(3))
nlat=where(lat ge limit(0) and lat le limit(2))
rlon=rnge(nlon)
rlat=rnge(nlat)
printf,20,'grd_sz','xmin','ymin','xmax','ymax','n_cols','n_rows','n_months',format='(8a10)'
if keyword_set(ddc) then begin
 printf,20,dxy(0),0.25,lat(rlat(0)),359.75,lat(rlat(1)),$
 n_elements(nlon),n_elements(nlat),12,form='(5f10.2,3i10)'
endif else begin
 printf,20,dxy(0),lon(rlon(0)),lat(rlat(0)),lon(rlon(1)),lat(rlat(1)),$
 n_elements(nlon),n_elements(nlat),12,form='(5f10.2,3i10)'
endelse
for im=0,11 do begin
 case 1 of
 keyword_set(ddc): begin
  for lat=rlat(1),rlat(0),-1 do $ 
  printf,20,grid(360:719,lat,im),grid(0:359,lat,im),format='(720i5)'
 end
 else: for lat=rlat(0),rlat(1) do printf,20,grid(rlon(0):rlon(1),lat,im),format='(720i5)'
 endcase
endfor
close,20 
if keyword_set(compress) then spawn,string('compress -f ',ascfl)
if keyword_set(zip) then spawn,'zip -m -D '+ascfl+'.zip  '+ascfl
if keyword_set(gzip) then spawn,'gzip -f '+ascfl 
spawn,'chmod a+r '+ascfl+'*'
end
