; interrogates .glo file but does not load it
; called with the ModelChosen (### note ###) to which the .glo ought to conform
; returns file details

pro CheckGlo, ModelChosen, FilePath, FileInfo, NoPrompt=NoPrompt, CallFile=CallFile

ExitStatus = 0
FilePath = "" & 	FileInfo = "" & 	GloFormat = "" & 	ModelFilePath = ""
ModelLongN = 0 & 	ModelLatN = 0 & 	Trash=""
MissVal = -999.0

if (keyword_set(CallFile)) then begin
  FilePath = CallFile
endif else begin
  FilePath = ""
endelse

while (ExitStatus NE 1) do begin				; initial interrogation
 OpenStatus = -1
 while (OpenStatus NE 0) do begin
  if (FilePath EQ "") then begin
  	if (NOT keyword_set(NoPrompt)) then print, "  > Enter the filepath of the .glo file: "
  	read, FilePath
  endif
  FilePath = strtrim(FilePath,2)
  openr, lunGlo, FilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then begin
    print, "  > File cannot be opened. Re-enter filepath."
    FilePath = ""
  endif
 endwhile  

 readf, lunGlo, FileInfo,  format='(a80)'			; title
 readf, lunGlo, GloFormat, format='(a10)'			; format
 FileInfo  = strtrim (FileInfo ,2)
 GloFormat = strtrim (GloFormat,2)
 
 if (strmid (GloFormat,1,2) EQ '10') then begin
   XLetter = 4
 endif else begin
   XLetter = 3
 endelse
 
 FormatType = strmid (GloFormat, (XLetter-1), 1)
 if (FormatType NE 'E' AND FormatType NE 'F') then begin
    free_lun, lunGlo
    openr, lunGlo, FilePath, /get_lun
    readf, lunGlo, FileInfo, format='(a80)'			; title
    GloFormat = '(8F12.4)'					; format
 endif

 readf, lunGlo, ModelLongN, ModelLatN, format='(2i6)'		; dims
 readf, lunGlo, ModelFilePath, format='(a80)'			; model details filepath
 ModelFilePath = strtrim(ModelFilePath,2) 
 								; get check details
 CheckModel = ModelChosen
 if (CheckModel GE 100) then CheckModel = CheckModel - 100
 SelectModel, CheckModel, CheckFilePath, CheckLongN, CheckLatN

 if (CheckFilePath EQ ModelFilePath) then begin			; perform check
   ExitStatus = 1
   free_lun, lunGlo
 endif else begin
   free_lun, lunGlo
   ExitStatus = 1
   
   openr, lunChk, CheckFilePAth, /get_lun
   readf, lunChk, trash, format="(a)"
   readf, lunChk, CheckLongN,CheckLatN, format="(2i4)"
   free_lun, lunChk
   
   if (CheckLongN ne ModelLongN or CheckLatN ne ModelLatN) then begin
     print, "  > @@@@@ FATAL: File is on the wrong model grid. @@@@@"
     print, strtrim(CheckFilePath)
     print, strtrim(ModelFilePath)
   endif
 endelse
endwhile

; print, "  > ", strtrim(FileInfo,2)				; print to show success in identifying file

end
