; gridrefs = [Along,Alat,Blong,Blat]
; use LinesTyle, Color, etc as  keyword parameters

pro DrawTrueLine, GridRefs, _extra=e

ALong = GridRefs[0]
BLong = GridRefs[2]
ALat  = GridRefs[1]
BLat  = GridRefs[3]

LongN = ceil (abs (BLong - ALong))
LatN  = ceil (abs (BLat  - ALat ))

if (LatN EQ 0) then begin
  
  CoordN   = LongN
  LongRefs = fltarr (CoordN)
  LatRefs  = fltarr (CoordN)

  for XLong = 0, (CoordN-2) do begin
    if (ALong GT Blong) then LongRefs [XLong] = ALong - XLong 
    if (ALong LT Blong) then LongRefs [XLong] = ALong + XLong 
  endfor
  LongRefs [CoordN-1] = BLong

  LatRefs [*] = ALat

endif else if (LongN EQ 0) then begin

  CoordN   = LatN
  LongRefs = fltarr (CoordN)
  LatRefs  = fltarr (CoordN)

  for XLat = 0, (CoordN-2) do begin
    if (ALat GT BLat) then LatRefs [XLat] = ALat - XLat 
    if (ALat LT BLat) then LatRefs [XLat] = ALat + XLat 
  endfor
  LatRefs [CoordN-1] = BLat

  LongRefs [*] = ALong

endif else begin

  if (LongN GT LatN) then CoordN = LongN
  if (LongN LE LatN) then CoordN = LatN
  LongRefs = fltarr (CoordN)
  LatRefs  = fltarr (CoordN)
  
  LongFract = (BLong - ALong) / CoordN
  LatFract  = (BLat  - ALat ) / CoordN
  
  for XCoord = 0, (CoordN-1) do begin
    LongRefs [XCoord] = ALong + (XCoord * LongFract)
    LatRefs  [XCoord] = ALat  + (XCoord * LatFract )
  endfor
  
endelse

for XCoord = 0, (CoordN-2) do begin
  plots, [LongRefs[XCoord],LongRefs[XCoord+1]], [LatRefs[XCoord],LatRefs[XCoord+1]], _extra=e  	
endfor

end
