; loads all scales from file

pro GetScales, ScaleN, ScaleName, ScaleColTab, ScaleSeg, ScaleLimits

ScaleN   = 0
DatumCha = ""
DatumInt = 0
DatumFlt = 0.0D

ScaleFilePath = "/cru/tyn1/f709762/goglo/glo-scales.ref"
openr, lunScale, ScaleFilePath, /get_lun

readf, lunScale, ScaleN, format='(i6)'			; no. of scales

ScaleName     = strarr (ScaleN)
ScaleName [*] = ""

ScaleColTab     = intarr (ScaleN)
ScaleColTab [*] = 0

ScaleSeg        = intarr (ScaleN)
ScaleSeg [*]    = 0

ScaleLimits       = fltarr (ScaleN,4)			; 0=data-min 1=data-max 2=col-min 3=col-max
ScaleLimits [*,*] = 0.0

for XScale = 0, (ScaleN-1) do begin
    readf, lunScale, DatumCha, format='(a10)'
    ScaleName [XScale] = strtrim (DatumCha, 2)
endfor
  
for XScale = 0, (ScaleN-1) do begin
    readf, lunScale, DatumInt, format='(i4)'
    ScaleColTab [XScale] = DatumInt
endfor
  
for XScale = 0, (ScaleN-1) do begin
    readf, lunScale, DatumInt, format='(i4)'
    ScaleSeg [XScale] = DatumInt
endfor
  
for XBound = 0, 3 do begin
  for XScale = 0, (ScaleN-1) do begin
    readf, lunScale, DatumFlt, format='(f10.2)'
    ScaleLimits [XScale, XBound] = DatumFlt
  endfor
endfor

free_lun, lunScale

end
