; returns the specifications for the viewing boundaries

pro GetViewBounds, ViewN, ViewName, ViewKeyWords, ViewBounds, ViewFullName=ViewFullName

ViewN    = 0 & DatumCha = "" & DatumFull = "" & DatumInt = 0 & DatumFlt = 0.0

ViewFilePath = "/cru/tyn1/f709762/goglo/glo-views.ref"
openr, lunView, ViewFilePath, /get_lun

readf, lunView, ViewN, format='(i6)'			; no. of views

ViewName     = strarr (ViewN)
ViewName [*] = ""

ViewFullName     = strarr (ViewN)
ViewFullName [*] = ""

ViewKeyWords       = strarr (ViewN,3)	; 0=proj, 1=coas/cont, 2=coun/bare
ViewKeyWords [*,*] = ""

ViewBounds       = fltarr (ViewN,4)	; lonmin, lonmax, latmin, latmax
ViewBounds [*,*] = 0.0

for XView = 0, (ViewN-1) do begin
    readf, lunView, DatumCha, DatumFull, format='(a10,a30)'
    ViewName     [XView] = strtrim (DatumCha,  2)
    ViewFullName [XView] = strtrim (DatumFull, 2)
endfor
  
for XWord = 0, 2 do begin
  for XView = 0, (ViewN-1) do begin
    readf, lunView, DatumCha, format='(a4)'
    ViewKeyWords [XView, XWord] = DatumCha
  endfor
endfor
  
for XBound = 0, 3 do begin
  for XView = 0, (ViewN-1) do begin
    readf, lunView, DatumFlt, format='(f7.2)'
    ViewBounds [XView, XBound] = DatumFlt
  endfor
endfor
  
free_lun, lunView

end
