; GrabInfo : obtains information from filepath,fileinfo, and the keyboard
;	   : returns all the details in Info
; if information already exists, place it as appropriate in Info before calling this routine
; if the region to plot is not selected prior to call, on return call GetViewBounds and use index ChosenView

pro GrabInfo, FilePath, FileInfo, Info, ChosenView, QBarInfo

MissVal = -999.0 & InputText = "
RefName = "missing" & SeasName = "missing" & PeriName = "missing" & EmitName = "missing" & GcmName = "missing"

if (Info[0] EQ "missing") then SearchVari, FilePath, VariName, UnitName
Info[0] = VariName  
Info[3] = UnitName

InputInt = -1 
while (Info[1] EQ "missing") do begin
  print, "  > Identify the statistic (0=list): "
  read, InputInt
    
  if (InputInt EQ 0) then begin
    print, "  >    1=mean, 2=response, 3=anom(abs), 4=diff, 5=anom%"
  endif else begin
    if (InputInt EQ 1) then Info[1] = 'mean'
    if (InputInt EQ 2) then Info[1] = 'response'
    if (InputInt EQ 3) then Info[1] = 'anomaly'
    if (InputInt EQ 4) then Info[1] = 'difference'
    if (InputInt EQ 5) then Info[1] = 'anomalyPC'
    if (Info[1] EQ "anomalyPC") then Info[3] = "percentage"
    if (Info[1] EQ "missing") then print, "  > Try again."
  endelse
endwhile

if (QBarInfo EQ 1 OR QBarInfo EQ 3) then begin
 if (Info[1] NE "mean") then SearchRef, FilePath, FileInfo, RefName
 Info[2] = RefName  

 InputInt = -1
 while (Info[4] EQ "missing") do begin
  GetViewBounds, ViewN, ViewName, ViewKeyWords, ViewBounds, ViewFullName=ViewFullName
  
  if (ChosenView NE MissVal AND ChosenView LT ViewN) then Info[4] = ViewFullName[ChosenView]
  
  if (Info[4] EQ "missing") then begin
    print, "  > Identify the region to plot (0=list): "
    read, InputInt
    
    if (InputInt EQ 0) then begin
      for XView = 0, (ViewN-1) do begin
        print, "  > ", XView, " : ", ViewName[XView], format='(a4,i4,a3,a10)'
      endfor
    endif else begin
      if (InputInt GE 0 AND InputInt LT ViewN) then begin
      	Info[4] = ViewFullName [InputInt]
      	ChosenView = InputInt
      endif else begin
        print, "  > Try again."
      endelse
    endelse
  endif
 endwhile

 if (Info[5] EQ "missing") then SearchSeas,FilePath,FileInfo,SeasName
 Info[5] = SeasName

 if (Info[6] EQ "missing") then SearchPeri,FilePath,FileInfo,PeriName,Century
 Info[6] = PeriName

 if (Century LT 21) then begin
  print, "  > Is the data observed (20=yes,21=no) ? "
  read, Century
 endif

 if (Century EQ 21) then begin
  if (Info[7] EQ "missing") then SearchEmit, FilePath, FileInfo, EmitName
  Info[7] = EmitName
  
  GlobalTText = "(global temperature)"
  if (Info[8] EQ "missing") then SearchGcm,  FilePath, FileInfo, GcmName, GlobalTText
  Info[8] = GcmName
  
  RegClimText = "(regional climate)"
  if (Info[9] EQ "missing") then SearchGcm,  FilePath, FileInfo, GcmName, RegClimText
  Info[9] = GcmName
 endif else begin
  Info[7] = "observed"
 endelse
endif

end
