; call with first,last years of data to plot, background and foreground colours, character characteristics
; XGridSet,YGridSet (0=no grid,1=grid)

pro InitDayPlot, PlotYear0,PlotYear1, BGCol,FGCol, MyCharSize,MyCharThick, XGridSet,YGridSet

if (XGridSet EQ 1) then begin
  XGrid = 1.0
endif else begin
  XGrid = 0.0 -  (float(MyCharThick)/100.0)
endelse

if (YGridSet EQ 1) then begin
  YGrid = 1.0
endif else begin
  YGrid = 0.0 - (float(MyCharThick)/100.0)
endelse

PlotYearN = PlotYear1 - PlotYear0

Year0 = float(PlotYear0) / 100.0 & Year1 = float(PlotYear1) / 100.0 
CenturyN = ceil(Year1) - floor(Year0)

Year0 = float(PlotYear0) /  50.0 & Year1 = float(PlotYear1) /  50.0 
FiftyN   = ceil(Year1) - floor(Year0)

Year0 = float(PlotYear0) /  40.0 & Year1 = float(PlotYear1) /  40.0 
FortyN   = ceil(Year1) - floor(Year0)

Year0 = float(PlotYear0) /  20.0 & Year1 = float(PlotYear1) /  20.0 
TwentyN  = ceil(Year1) - floor(Year0)

AcceptN  = floor(8.0 / float(MyCharSize))

if (TwentyN LE AcceptN) then begin
    Denom =  20
endif else begin
 if (FortyN LE AcceptN) then begin
    Denom =  40
 endif else begin
  if (FiftyN LE AcceptN) then begin
    Denom =  50
  endif else begin
    Denom = 100
  endelse
 endelse
endelse

Year0     = float(PlotYear0) / float(Denom)
PlotYear0 = floor(Year0) * Denom

Year1     = float(PlotYear1) / float(Denom)
PlotYear1 = ceil (Year1) * Denom

PlotYearN = PlotYear1 - PlotYear0
PlotGapN  = PlotYearN / Denom

XTickLoc = intarr (PlotGapN+1)
for TickX = 0, PlotGapN do begin
  XTickLoc(TickX) = PlotYear0 + (Denom*TickX)
endfor

YTickLoc = [0,31,60,91,121,152,182,213,244,274,305,335,366]
YTickLab = [' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ']

plot, [0,0,0], [0,0,0], $					; random line
  	Background=BGCol,$					; background colour
  	Color=FGCol,$						; colour		
  	XStyle=1, $						; axis constraint ?
  	YStyle=1, $						; draws only one axis
  	XRange=[(PlotYear0-0.5),(PlotYear1+0.5)],$		; x axis limits
  	YRange=[366.5,-0.5],$					; y axis limits
  	XTitle="year AD",$					; x axis title
  	XTicks=PlotGapN,XTickV=XTickLoc,$			; x tick marks
  	YTicks=12,YTickV=YTickLoc,YTickName=YTickLab,$  	; y tick marks
  	XTickLen=XGrid,$					; tick marks outside or grid lines
  	YTickLen=YGrid,$					; tick marks outside or grid lines
  	CharSize=MyCharSize,$ 					; size of annotations
  	CharThick=MyCharThick, font=5,$				; thickness of annotations
	XThick=MyCharThick,YThick=MyCharThick,$			; axis thicknesses
  	/NoData

xx = [PlotYear0-(Denom)]

xyouts, xx, 21,  'Jan', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 50,  'Feb', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 81,  'Mar', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 111, 'Apr', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 142, 'May', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 172, 'Jun', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 203, 'Jul', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 234, 'Aug', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 264, 'Sep', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 295, 'Oct', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 325, 'Nov', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
xyouts, xx, 356, 'Dec', color=FGCol, font=5, charsize=MyCharSize, charthick=MyCharThick
  
end
