; interrogates .day file and loads it
; returns 

pro LoadDay, YearAD, Daily

ExitStatus = 0
DayFilePath = "" & 	DayFormat = "" & 	Trash = ""
Year0 = 0 &		Year1 = 0
MissVal = -999.0

Datum0=0.0 & 	Datum1=0.0 &	Datum2=0.0 &	Datum3=0.0
Datum4=0.0 & 	Datum5=0.0 &	Datum6=0.0 & 	Datum7=0.0
Datum8=0.0 & 	Datum9=0.0 &	Datum10=0.0 & 	Datum11=0.0

print, "  > Enter the filepath of the .day file: "

OpenStatus = -1
while (OpenStatus NE 0) do begin
  read, DayFilePath
  DayFilePath = strtrim(DayFilePath,2)
  openr, lunDay, DayFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
endwhile  

readf, lunDay, Trash, format='(a80)'				; ownership and date stamp
readf, lunDay, Trash, format='(a80)'				; time period and variable
readf, lunDay, Trash, Year0, Trash, Year1, Trash, DayFormat, format='(a9,i4,a1,i4,a36,a20)'
readf, lunDay, Trash, format='(a80)'				; column titles

print, "  > First and last years in file: ", Year0, Year1

DayFormat = strtrim (DayFormat,2)

YearN  = Year1 - Year0 + 1
MonthN = 12
DayN   = 31
 
Daily  = dblarr (YearN,MonthN,DayN)				; output arrays
YearAD = intarr (YearN)

for XYear = 0, (YearN-1) do begin				; fill YearAD	
  YearAD(XYear) = Year0 + XYear
endfor

for XYear = 0, (YearN-1) do begin				; fill Daily
  for XDay = 0, (DayN-1) do begin
    readf, lunDay, Trash,Trash, $
    	Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7,Datum8,Datum9,Datum10,Datum11,format=DayFormat
    Daily (XYear, 0,XDay) = Datum0
    Daily (XYear, 1,XDay) = Datum1
    Daily (XYear, 2,XDay) = Datum2
    Daily (XYear, 3,XDay) = Datum3
    Daily (XYear, 4,XDay) = Datum4
    Daily (XYear, 5,XDay) = Datum5
    Daily (XYear, 6,XDay) = Datum6
    Daily (XYear, 7,XDay) = Datum7
    Daily (XYear, 8,XDay) = Datum8
    Daily (XYear, 9,XDay) = Datum9
    Daily (XYear,10,XDay) = Datum10
    Daily (XYear,11,XDay) = Datum11
  endfor
endfor

free_lun, lunDay

DailyTot    =      0.0
DailyEn     =      0.0
DailyMin    =  10000.0
DailyMax    = -10000.0

for XYear = 0, (YearN-1) do begin				; check properties of .day
 for XMonth = 0, (MonthN-1) do begin
  for XDay = 0, (DayN-1) do begin
    if (Daily(XYear,XMonth,XDay) NE MissVal) then begin
     
     DailyTot = DailyTot + Daily(XYear,XMonth,XDay)
     DailyEn  = DailyEn  + 1
     
     if            (Daily(XYear,XMonth,XDay) LT DailyMin) then begin
      DailyMin = Daily(XYear,XMonth,XDay)
     endif else if (Daily(XYear,XMonth,XDay) GT DailyMax) then begin
      DailyMax = Daily(XYear,XMonth,XDay)
     endif
    
    endif
  endfor
 endfor
endfor

Valid    = round (DailyEn)
DailyMean = DailyTot / DailyEn

print, "  > Valid, Mean, Min, Max: ", Valid, DailyMean, DailyMin, DailyMax, format='(a26,i6,3f10.4)'

end
