; saves .glo file

pro SaveGlo, ModelChosen, GloSlice, CallFile=CallFile, CallTitle=CallTitle

ExitStatus = 0
GloFilePath = "" & 	GloTitle = "" & 	GloFormat = "" & 	CheckFilePath = ""
MissVal = -999.0

Datum0=0.0 & 	Datum1=0.0 &	Datum2=0.0 &	Datum3=0.0
Datum4=0.0 & 	Datum5=0.0 &	Datum6=0.0 & 	Datum7=0.0 & Datum8=0.0 & Datum9=0.0

SaveModel = ModelChosen						; get model details
if (ModelChosen GE 100) then SaveModel = SaveModel - 100								; dims to save
SelectModel, SaveModel, ModelFilePath, ModelLongN, ModelLatN

if            ((float(ModelLongN)/8.0) EQ fix(float(ModelLongN)/8.0)) then begin
  GloFormat = '(8E12.4)' & SaveColN = 8
endif else if ((float(ModelLongN)/10.0) EQ fix(float(ModelLongN)/10.0)) then begin
  GloFormat = '(10E12.4)' & SaveColN = 10
endif else if ((float(ModelLongN)/6.0) EQ fix(float(ModelLongN)/6.0)) then begin
  GloFormat = '(6E12.4)' & SaveColN = 6
endif else begin
  print, "  > ##### SaveGlo: ERROR: LongN is not divisible by 6 or 8 or 10 #####"
endelse
GloFormat = strtrim (GloFormat,2)

if (ModelChosen GE 100) then begin				; remove extra column
  SelectModel, ModelChosen, ExtendFilePath, ExtendLongN, ExtendLatN, /Extend
  
  if (ExtendLongN GT ModelLongN) then begin
   OldSlice = GloSlice
   GloSlice = dblarr (ModelLongN,ModelLatN)
   for XLong = 0, (ModelLongN-1) do begin
    GloSlice [XLong,*] = OldSlice [XLong,*]
   endfor 
  endif
endif

if (keyword_set(Calltitle)) then begin
  GloTitle = strtrim (CallTitle,2)
endif else begin
  print, "  > Enter the title of the .glo file: "
  read, GloTitle
  GloTitle = strtrim (GloTitle,2)
endelse

if (keyword_set(CallFile)) then begin
 GloFilePath = strtrim(CallFile,2)
 openw, lunGlo, GloFilePath, /get_lun
endif else begin
 OpenStatus = -1
 print, "  > Enter the filepath of the .glo file: "
 while (OpenStatus NE 0) do begin
  read, GloFilePath
  GloFilePath = strtrim(GloFilePath,2)
  openw, lunGlo, GloFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
 endwhile
endelse

printf, lunGlo, GloTitle,  format='(a80)'			; title
printf, lunGlo, GloFormat, format='(a10)'			; format
printf, lunGlo, ModelLongN, ModelLatN, format='(2i6)'		; dims
printf, lunGlo, ModelFilePath, format='(a80)'			; model details filepath

if (SaveColN EQ 8) then begin
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XEight = 0, (floor(ModelLongN/8)-1) do begin
    Long0 = XEight*8
  
    Datum0 = GloSlice ((Long0+0),XLat)
    Datum1 = GloSlice ((Long0+1),XLat)
    Datum2 = GloSlice ((Long0+2),XLat)
    Datum3 = GloSlice ((Long0+3),XLat)

    Datum4 = GloSlice ((Long0+4),XLat)
    Datum5 = GloSlice ((Long0+5),XLat)
    Datum6 = GloSlice ((Long0+6),XLat)
    Datum7 = GloSlice ((Long0+7),XLat)
  
    printf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format=GloFormat
  endfor
 endfor
endif else if (SaveColN EQ 10) then begin
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XTen = 0, (floor(ModelLongN/10)-1) do begin
    Long0 = XTen*10
  
    Datum0 = GloSlice ((Long0+0),XLat)
    Datum1 = GloSlice ((Long0+1),XLat)
    Datum2 = GloSlice ((Long0+2),XLat)
    Datum3 = GloSlice ((Long0+3),XLat)
    Datum4 = GloSlice ((Long0+4),XLat)

    Datum5 = GloSlice ((Long0+5),XLat)
    Datum6 = GloSlice ((Long0+6),XLat)
    Datum7 = GloSlice ((Long0+7),XLat)
    Datum8 = GloSlice ((Long0+8),XLat)
    Datum9 = GloSlice ((Long0+9),XLat)
  
    printf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7,Datum8,Datum9, format=GloFormat
  endfor
 endfor
endif else if (SaveColN EQ 6) then begin
 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XTen = 0, (floor(ModelLongN/6)-1) do begin
    Long0 = XTen*6
  
    Datum0 = GloSlice ((Long0+0),XLat)
    Datum1 = GloSlice ((Long0+1),XLat)
    Datum2 = GloSlice ((Long0+2),XLat)
    Datum3 = GloSlice ((Long0+3),XLat)
    Datum4 = GloSlice ((Long0+4),XLat)
    Datum5 = GloSlice ((Long0+5),XLat)
  
    printf, lunGlo, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5, format=GloFormat
  endfor
 endfor
endif

free_lun, lunGlo

end
