; saves .ref to file
; called with RegN, ModelLongN, ModelLatN, SelArray, RegSize, RegName

pro SaveRef, RegN, ModelLongN, ModelLatN, SelArray, RegSize, RegName

RefFilePath = "" & 	RefTitle = ""
MissVal = -999.0
DatumCha = ""
Int0 = 0L &	Int1 = 0L &	Int2 = 0L &	Int3 = 0L
Int0 = 0L &	Int5 = 0L &	Int6 = 0L &	Int7 = 0L
MapIDLReg       = lonarr (ModelLongN, ModelLatN)
MapIDLReg [*,*] = SelArray [*,*]

print, "  > Enter title to save: "					; specify title
read, RefTitle
RefTitle = strtrim(RefTitle,2)

print, "  > Enter the filepath of the .ref file to save: "
									; specify file
OpenStatus = -1
while (OpenStatus NE 0) do begin
  read, RefFilePath
  RefFilePath = strtrim(RefFilePath,2)
  openw, lunRef, RefFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
endwhile  

printf, lunRef, RefTitle,  		     format='(a40)'		; write title
printf, lunRef, RegN, ModelLongN, ModelLatN, format='(i6,2i4)'		; write dims

for XReg = 0L, (RegN-1) do begin					; write RegName
    DatumCha = RegName (XReg)
    printf, lunRef, DatumCha, format="(A20)"
endfor

TotValid = 0L
for XLong = 0, (ModelLongN-1) do begin				; adjust MapIDLReg from 0...(RegN-1)
  for XLat = 0, (ModelLatN-1) do begin				;    to 1...RegN
    if (MapIDLReg (XLong,XLat) NE MissVal) then begin
    	MapIDLReg (XLong,XLat) = MapIDLReg (XLong,XLat) + 1
    	TotValid               = TotValid + 1
    endif
  endfor
endfor

if ((ModelLongN mod 8) eq 0) then begin
 print, "  > Saving in eights"
 LongEightN = round (ModelLongN / 8)
 for XLat = 0, (ModelLatN-1) do begin					; write MapIDLReg,with MissVal or XReg
  for XEight = 0, (LongEightN-1) do begin
    Int0 = MapIDLReg (((XEight*8)+0),XLat)
    Int1 = MapIDLReg (((XEight*8)+1),XLat)
    Int2 = MapIDLReg (((XEight*8)+2),XLat)
    Int3 = MapIDLReg (((XEight*8)+3),XLat)
    Int4 = MapIDLReg (((XEight*8)+4),XLat)
    Int5 = MapIDLReg (((XEight*8)+5),XLat)
    Int6 = MapIDLReg (((XEight*8)+6),XLat)
    Int7 = MapIDLReg (((XEight*8)+7),XLat)

    printf, lunRef, Int0, Int1, Int2, Int3, Int4, Int5, Int6, Int7, format="(8(i6))"    
  endfor
 endfor
endif else if ((ModelLongN mod 10) eq 0) then begin
 print, "  > Saving in tens"
 LongEightN = round (ModelLongN / 10)
 for XLat = 0, (ModelLatN-1) do begin					; write MapIDLReg,with MissVal or XReg
  for XEight = 0, (LongEightN-1) do begin
    Int0 = MapIDLReg (((XEight*10)+0),XLat)
    Int1 = MapIDLReg (((XEight*10)+1),XLat)
    Int2 = MapIDLReg (((XEight*10)+2),XLat)
    Int3 = MapIDLReg (((XEight*10)+3),XLat)
    Int4 = MapIDLReg (((XEight*10)+4),XLat)
    Int5 = MapIDLReg (((XEight*10)+5),XLat)
    Int6 = MapIDLReg (((XEight*10)+6),XLat)
    Int7 = MapIDLReg (((XEight*10)+7),XLat)
    Int8 = MapIDLReg (((XEight*10)+8),XLat)
    Int9 = MapIDLReg (((XEight*10)+9),XLat)

    printf, lunRef, Int0, Int1, Int2, Int3, Int4, Int5, Int6, Int7, Int8, Int9, format="(10i6)"    
  endfor
 endfor
endif else if ((ModelLongN mod 6) eq 0) then begin
 print, "  > Saving in sixes"
 LongEightN = round (ModelLongN / 6)
 for XLat = 0, (ModelLatN-1) do begin					; write MapIDLReg,with MissVal or XReg
  for XEight = 0, (LongEightN-1) do begin
    Int0 = MapIDLReg (((XEight*6)+0),XLat)
    Int1 = MapIDLReg (((XEight*6)+1),XLat)
    Int2 = MapIDLReg (((XEight*6)+2),XLat)
    Int3 = MapIDLReg (((XEight*6)+3),XLat)
    Int4 = MapIDLReg (((XEight*6)+4),XLat)
    Int5 = MapIDLReg (((XEight*6)+5),XLat)

    printf, lunRef, Int0, Int1, Int2, Int3, Int4, Int5, format="(6i6)"    
  endfor
 endfor
endif else begin
 print, "  > @@@@@ SaveRef.pro : LongN not divisible by 8,10,6 @@@@@"
endelse

free_lun, lunRef

print, "  > Regions saved, and total valid boxes: ", RegN, TotValid, format='(a42,i8,i8)'

end
