; saves .ref to .glo file
; called with RegN, ModelLongN, ModelLatN, SelArray, RegCol

pro SaveRefGlo, RegN, ModelLongN, ModelLatN, SelArray, RegCol

GloFilePath = "" & 	RefFilePath = "" & 	GloTitle = ""
MissVal = -999.0
DatumCha = ""
Flt0 = 0.0 &	Flt1 = 0.0 &	Flt2 = 0.0 &	Flt3 = 0.0
Flt4 = 0.0 &	Flt5 = 0.0 &	Flt6 = 0.0 &	Flt7 = 0.0 & Flt8=0.0 & Flt9=0.0
MapIDLReg       = intarr (ModelLongN, ModelLatN)
MapIDLReg [*,*] = SelArray [*,*]

if            ((float(ModelLongN)/8.0) EQ fix(float(ModelLongN)/8.0)) then begin
  GloFormat = '(8E12.4)' & SaveColN = 8
endif else if ((float(ModelLongN)/10.0) EQ fix(float(ModelLongN)/10.0)) then begin
  GloFormat = '(10E12.4)' & SaveColN = 10
endif else begin
  print, "  > ##### SaveGlo: ERROR: LongN is not divisible by 8 or 10 #####"
endelse
GloFormat = strtrim (GloFormat,2)

print, "  > Enter title to save: "					; specify title
read, GloTitle
GloTitle = strtrim(GloTitle,2)

print, "  > Enter the filepath of the .glo file to save: "
									; specify file
OpenStatus = -1
while (OpenStatus NE 0) do begin
  read, GloFilePath
  GloFilePath = strtrim(GloFilePath,2)
  openw, lunGlo, GloFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
endwhile  

print, "  > Enter the filepath of the model .ref file: "
									; specify file
OpenStatus = -1
while (OpenStatus NE 0) do begin
  read, RefFilePath
  RefFilePath = strtrim(RefFilePath,2)
  openr, lunRef, RefFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
  if (OpenStatus EQ 0) then free_lun, lunRef
endwhile  

printf, lunGlo, GloTitle,  		     format='(a80)'		; write title
printf, lunGlo, GloFormat,  		     format='(a8)'		; write format
printf, lunGlo, ModelLongN, ModelLatN, 	     format='(2i6)'		; write dims
printf, lunGlo, RefFilePath,  		     format='(a80)'		; write ref file path

LongEightN = round (ModelLongN / 8)

for XLat = 0, (ModelLatN-1) do begin					; write colours
  for XEight = 0, (LongEightN-1) do begin    
    if (SelArray(((XEight*8)+0),XLat) NE MissVal) then Flt0 = RegCol (SelArray(((XEight*8)+0),XLat))
    if (SelArray(((XEight*8)+1),XLat) NE MissVal) then Flt1 = RegCol (SelArray(((XEight*8)+1),XLat))
    if (SelArray(((XEight*8)+2),XLat) NE MissVal) then Flt2 = RegCol (SelArray(((XEight*8)+2),XLat))
    if (SelArray(((XEight*8)+3),XLat) NE MissVal) then Flt3 = RegCol (SelArray(((XEight*8)+3),XLat))
    if (SelArray(((XEight*8)+4),XLat) NE MissVal) then Flt4 = RegCol (SelArray(((XEight*8)+4),XLat))
    if (SelArray(((XEight*8)+5),XLat) NE MissVal) then Flt5 = RegCol (SelArray(((XEight*8)+5),XLat))
    if (SelArray(((XEight*8)+6),XLat) NE MissVal) then Flt6 = RegCol (SelArray(((XEight*8)+6),XLat))
    if (SelArray(((XEight*8)+7),XLat) NE MissVal) then Flt7 = RegCol (SelArray(((XEight*8)+7),XLat))

    printf, lunGlo, Flt0, Flt1, Flt2, Flt3, Flt4, Flt5, Flt6, Flt7, format=GloFormat    
  endfor
endfor

if (SaveColN EQ 8) then begin
 LongEightN = round (ModelLongN / 8)

 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XEight = 0, (floor(ModelLongN/8)-1) do begin
    if (SelArray(((XEight*8)+0),XLat) NE MissVal) then Flt0 = RegCol (SelArray(((XEight*8)+0),XLat))
    if (SelArray(((XEight*8)+1),XLat) NE MissVal) then Flt1 = RegCol (SelArray(((XEight*8)+1),XLat))
    if (SelArray(((XEight*8)+2),XLat) NE MissVal) then Flt2 = RegCol (SelArray(((XEight*8)+2),XLat))
    if (SelArray(((XEight*8)+3),XLat) NE MissVal) then Flt3 = RegCol (SelArray(((XEight*8)+3),XLat))
    if (SelArray(((XEight*8)+4),XLat) NE MissVal) then Flt4 = RegCol (SelArray(((XEight*8)+4),XLat))
    if (SelArray(((XEight*8)+5),XLat) NE MissVal) then Flt5 = RegCol (SelArray(((XEight*8)+5),XLat))
    if (SelArray(((XEight*8)+6),XLat) NE MissVal) then Flt6 = RegCol (SelArray(((XEight*8)+6),XLat))
    if (SelArray(((XEight*8)+7),XLat) NE MissVal) then Flt7 = RegCol (SelArray(((XEight*8)+7),XLat))

    printf, lunGlo, Flt0, Flt1, Flt2, Flt3, Flt4, Flt5, Flt6, Flt7, format=GloFormat    
  endfor
 endfor
endif else if (SaveColN EQ 10) then begin
 LongTenN = round (ModelLongN / 10)

 for XLat = 0, (ModelLatN-1) do begin				; load into output array
  for XTen = 0, (floor(ModelLongN/10)-1) do begin
    if (SelArray(((XTen*10)+0),XLat) NE MissVal) then Flt0 = RegCol (SelArray(((XTen*10)+0),XLat))
    if (SelArray(((XTen*10)+1),XLat) NE MissVal) then Flt1 = RegCol (SelArray(((XTen*10)+1),XLat))
    if (SelArray(((XTen*10)+2),XLat) NE MissVal) then Flt2 = RegCol (SelArray(((XTen*10)+2),XLat))
    if (SelArray(((XTen*10)+3),XLat) NE MissVal) then Flt3 = RegCol (SelArray(((XTen*10)+3),XLat))
    if (SelArray(((XTen*10)+4),XLat) NE MissVal) then Flt4 = RegCol (SelArray(((XTen*10)+4),XLat))
    if (SelArray(((XTen*10)+5),XLat) NE MissVal) then Flt5 = RegCol (SelArray(((XTen*10)+5),XLat))
    if (SelArray(((XTen*10)+6),XLat) NE MissVal) then Flt6 = RegCol (SelArray(((XTen*10)+6),XLat))
    if (SelArray(((XTen*10)+7),XLat) NE MissVal) then Flt7 = RegCol (SelArray(((XTen*10)+7),XLat))
    if (SelArray(((XTen*10)+8),XLat) NE MissVal) then Flt8 = RegCol (SelArray(((XTen*10)+8),XLat))
    if (SelArray(((XTen*10)+9),XLat) NE MissVal) then Flt9 = RegCol (SelArray(((XTen*10)+9),XLat))

    printf, lunGlo, Flt0, Flt1, Flt2, Flt3, Flt4, Flt5, Flt6, Flt7, Flt8, Flt9, format=GloFormat    
  endfor
 endfor
endif

free_lun, lunGlo

end
