; feed this routine with the filepath and file info line
; it will find the emissions scenario, if it is there to be found

pro SearchEmit, FilePath, FileInfo, EmitName

EmitName = "missing"
StringN = 16 & FoundN = 0

SearchStr = strarr (StringN)
SearchStr = ['GG','Ga','Gd','A1','A2','B1','B2','Obs',$
	     'gg','ga','gd','a1','a2','b1','b2','obs']

EmitStr = strarr (StringN)     
EmitStr = ['GG 1%','GG 1%','GG 0.5%','A1','A2','B1','B2','observations',$ 
	   'GG 1%','GG 1%','GG 0.5%','A1','A2','B1','B2','observations']

Text = strarr (2)
Text[0] = FilePath & Text[1] = FileInfo

for XText = 0, 1 do begin            
 if (FoundN EQ 0) then begin
  for XSearch = 0, (StringN-1) do begin
    if (strpos(Text[XText],SearchStr(XSearch)) NE -1) then begin
    	EmitName = EmitStr(XSearch)
    	FoundN = FoundN + 1
    endif
  endfor
 endif
endfor

if (FoundN NE 1) then begin
  EmitName = "missing"
  
  InputInt = -1 
  while (EmitName EQ "missing") do begin
   print, "  > Identify the emissions scenario (-1=list): "
   read, InputInt
    
   if (InputInt EQ -1) then begin
     for XString = 1, ((StringN/2)-1) do begin
       print, "  > ", XString, " : ", EmitStr(XString), format='(a4,i2,a3,a)'
     endfor
   endif else begin
     if (InputInt LT 0 OR InputInt GT ((StringN/2)-1)) then begin
       print, "  > Try again."
     endif else begin
       EmitName = EmitStr (InputInt)
     endelse
   endelse
  endwhile
endif

end
