pro TrimToScale, GloData, TrimData, DataBounds, SinglePrec=SinglePrec

MissVal = -999.0

GridDim = size (GloData)
LongN = GridDim [1]
LatN  = GridDim [2]

if (arg_present(SinglePrec)) then begin
  TrimData = fltarr (LongN,LatN)
endif else begin     
  TrimData = dblarr (LongN,LatN)
endelse

TrimData [*,*] = !Values.F_NaN

for XLong = 0, (LongN-1) do begin
   for XLat = 0, (LatN-1) do begin
      if (finite(GloData(XLong,XLat))) then begin
        if (GloData(XLong,XLat) NE MissVal) then begin
          if (GloData(XLong,XLat) LT DataBounds[0]) then begin
              TrimData(XLong,XLat) = DataBounds[0]
          endif else begin
            if (GloData(XLong,XLat) GT DataBounds[1]) then begin
              TrimData(XLong,XLat) = DataBounds[1]
            endif else begin
              TrimData(XLong,XLat) = GloData(XLong,XLat)
            endelse
          endelse 
        endif
      endif
   endfor
endfor

end
