! comfiles.f90
! module procedure written by Tim Mitchell in Dec 1999
! last modification on 23.08.00
! contains all routines for loading data from .com files

module ComFiles

implicit none

contains

!*******************************************************************************

subroutine LoadCom (JobYearN, JobADYear, LinLineN, LinNames, LinAnaSeries)

integer, pointer, dimension (:)			:: JobADYear
					! years AD of full job
character (len=80), pointer, dimension (:) 	:: LinNames
					! names of individual lines
real, pointer, dimension (:,:)			:: LinAnaSeries
					! datum: line, year

integer, intent (in)	:: JobYearN	! no. years in job
integer, intent (out)	:: LinLineN	! no. lines

integer, allocatable, dimension (:,:) 	:: FileTimes
real, allocatable, dimension (:,:) 	:: FileData

real, parameter :: MissVal = -999.0

character (len=80) :: GivenFile, LinFilePath, LinTitle
character (len=10) :: LinFormat

integer :: LinTimeN			! no. time steps in file
integer :: XLine, XTime
integer :: AllocStat			! status of allocation statement
integer :: ReadStatus			! status of user input
integer :: XLineTime, XLineStart
integer :: XOutTime, XOutStart

print*, "  > Enter the filepath of the .com file to load: "
do
	do
		read (*,*,iostat=ReadStatus), GivenFile
		if (ReadStatus.LE.0) exit
	end do
	
	inquire (file=GivenFile, name=LinFilePath)
	open (1, file=LinFilePath, status="old", iostat=ReadStatus)
	if (ReadStatus .EQ. 0) close (1)
	if (ReadStatus .EQ. 0) exit
end do

open (2, file=LinFilePath, status="old", access="sequential", form="formatted", &
		action="read")

read (2, fmt="(A80)"), LinTitle
read (2, fmt="(A10)"), LinFormat
read (2, fmt="(2I6)"), LinLineN, LinTimeN

print*, "  > File details: "
print*, adjustl(trim(LinTitle))
print*, adjustl(trim(LinFormat))
print*, LinLineN, LinTimeN

allocate (LinNames  (LinLineN), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: LoadCom: Allocation failure #####"

allocate (FileTimes (LinLineN, LinTimeN), &
	  FileData  (LinLineN, LinTimeN), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: LoadCom: Allocation failure #####"

do XLine = 1, LinLineN
  read (2, fmt="(a80)"), LinNames (XLine)
end do

do XLine = 1, LinLineN
 do XTime = 1, LinTimeN
  read (2, fmt="(I6)"), FileTimes (XLine, XTime)
 end do
end do

do XLine = 1, LinLineN
 do XTime = 1, LinTimeN
  read (2, fmt=LinFormat), FileData (XLine, XTime)
 end do
end do

close (2)

allocate (LinAnaSeries (LinLineN, JobYearN), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: LoadCom: Allocation failure #####"
LinAnaSeries = MissVal

do XLine = 1, LinLineN
 
 XLineStart = nint(MissVal)
 XLineTime = 0
 do
   XLineTime = XLineTime + 1
   if (FileTimes(XLine,XLineTime).NE.nint(MissVal)) XLineStart = XLineTime
   if (FileTimes(XLine,XLineTime).NE.nint(MissVal)) exit
   if (XLineTime.EQ.LinTimeN) exit
 end do
 
 if (XLineStart.NE.nint(MissVal)) then
  XOutStart = nint(MissVal)
  XOutTime  = 0
  do
    XOutTime = XOutTime + 1
    if (JobADYear(XOutTime).EQ.FileTimes(XLine,XLineStart)) XOutStart = XOutTime
    if (JobADYear(XOutTime).EQ.FileTimes(XLine,XLineStart)) exit
    if (XOutTime.EQ.JobYearN) exit
  end do
  
  XLineTime = XLineStart - 1
  
  if (XOutStart.NE.nint(MissVal)) then
   do XOutTime = XOutStart, JobYearN
     XLineTime = XLineTime + 1
     if (XLineTime.LE.LinTimeN) LinAnaSeries (XLine,XOutTime) = FileData (XLine,XLineTime)
   end do
  end if
  
 end if
end do

end subroutine LoadCom

!*******************************************************************************

end module ComFiles
