! jldatfiles.f90
! module in which all Jenk-Lamb .dat file routines are held
! contains: LoadJLDAT, SaveJLDAT

module JLDATFiles

use FileNames

implicit none

contains

!*******************************************************************************
! load the .dat files such as lamb_al.dat and lambjenks_all.dat
! note that it returns an integer array, 
!   and that non-existent days are -9 and unclassifiable are -1

subroutine LoadJLDAT (CallFile, YearAD, Data)

integer, pointer, dimension (:,:,:)	:: Data

integer, pointer, dimension (:) 	:: YearAD

character (len=80), intent(in)		:: CallFile	! can be blank

real, parameter :: MissVal = -999.0

integer :: ReadStatus, AllocStat
integer :: YearN, MonthN, DayN
integer :: XYear, XMonth, XDay
integer :: Year0, Year1

character (len=99) :: Header
character (len=80) :: LoadFile
character (len= 4) :: Suffix

!***************************************

Suffix = ".dat"
MonthN = 12
DayN   = 31

LoadFile = LoadPath (CallFile,Suffix)

open (2, file=LoadFile, status="old", access="sequential", form="formatted", action="read")

read (2,"(a99)"), Header
print "(a99)", Header

print*, "  > We assume that the file begins Jan 1st and ends Dec 31st."
print*, "  > Enter the first and last years AD in the file: "
do
	read (*,*,iostat=ReadStatus), Year0, Year1
	if (ReadStatus.GT.0) print*, "  > Must be two integers. Try again."
	if (Year0.GT.Year1)  print*, "  > First year after last. Try again."
	if (ReadStatus.LE.0.AND.Year0.LE.Year1) exit
end do
  
YearN = Year1 - Year0 + 1

allocate (YearAD (YearN),             &
	  Data   (YearN,MonthN,DayN), stat=AllocStat)
if (AllocStat.NE.0) print*, "  > ##### ERROR: LoadDAT: Allocation failure #####"

do XYear = 1, YearN
    YearAD (XYear) = Year0 - 1 + XYear
    
    do XMonth = 1, 12
      read (2,"(31i3)"), (Data(XYear,XMonth,XDay), XDay=1,31)
    end do
end do
  
close (2)

end subroutine LoadJLDAT

!*******************************************************************************
! save .dat files similar to lamb_al.dat and lambjenks_all.dat
! note that it believes that non-existent days are -9 and unclassifiable are -1

subroutine SaveJLDAT (CallFile, YearAD, Data)

integer, pointer, dimension (:,:,:)	:: Data

integer, pointer, dimension (:) 	:: YearAD

character (len=80), intent(in)		:: CallFile	! can be blank

real, parameter :: MissVal = -999.0

integer :: ReadStatus, AllocStat
integer :: YearN, MonthN, DayN
integer :: XYear, XMonth, XDay

character (len=99) :: Header
character (len=80) :: SaveFile
character (len= 4) :: Suffix

!***************************************

Suffix = ".dat"
MonthN = 12
DayN   = 31
YearN  = size (YearAD)

if (YearN.NE.size(Data,1)) then
  print*, "  > SaveDAT. Mismatch between YearAD and Data arrays. No save."
else
  print*, "  > The first and last years: ", YearAD(1), YearAD(YearN)
  print*, "  > Enter the header: "
  do
	read (*,*,iostat=ReadStatus), Header
	if (ReadStatus.GT.0) print*, "  > Must be a string. Try again."
	if (Header.EQ."")    print*, "  > Blank. Try again."
	if (ReadStatus.LE.0.AND.Header.NE."") exit
  end do

  SaveFile = SavePath (CallFile,Suffix)

  open (2, file=SaveFile, status="replace", access="sequential", form="formatted", action="write")
  
  write (2,"(a99)"), Header
  
  do XYear = 1, YearN
    do XMonth = 1, MonthN
      write (2,"(31i3)"), (Data(XYear,XMonth,XDay), XDay=1,31)
    end do
  end do
  
  close (2)
end if

end subroutine SaveJLDAT

!*******************************************************************************

end module JLDATFiles
