;
; Counts number of cores and numbers of sites in MXD data set
;
; All cores have "MAXD" at their head, therefore, grep M to get
; the core headers out
;
fn='mxd.allsites.all.dat'
spawn,'grep M '+fn,corename
;
ncore=n_elements(corename)
;
print,'File: '+fn
print,'Number of cores '+txt(ncore)
;
; The site name is unique and constant for all cores at that site, so
; extract it, sort it, and extract unique ones only.
;
sitename=strmid(corename,48)
stname=sitename[uniq(sitename)]
;
nsite=n_elements(stname)
print,'Number of sites '+txt(nsite)
;
print,'print,stname to see their names!'
;
end
