;
; Plots the location at 5 by 5 boxes in which chronologies fall
;
loadct,39
def_1color,50,color='mdgrey'
def_1color,51,color='red'
multi_plot,nrow=4,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)  &  coast.double=0
labels=def_labels(/off)
;
restore,filename='reglists.idlsave'
restore,filename='regboxes.idlsave'
;
for i = 0 , nreg-1 do begin
;
  fd1=reform(boxlists(*,*,i))
  dummy=where(finite(fd1),nboxxx)
  inter_boxfd,fd1,g.x,g.y,map=map,coast=coast,labels=labels,$
    title=regname(i)+'('+string(nboxxx,format='(I3)')+')',$
    levels=[0.5,1.5],c_colors=[51]
;
endfor
;
end
