;
; Makes mean timeseries of instrumental data
;
; Get region info
;
restore,filename='regboxes.idlsave'
;
; Define arrays
;
nyrmax=1995-1400+1
nmon=12
regts=fltarr(nyrmax*nmon,nreg)+!values.f_nan
regcover=fltarr(nyrmax*nmon,nreg)
;
; Now also want to keep groups of grid-box timeseries for the boxes that go
; into each regional mean
;
; Region 9 is ALL
ireg = 9
dummy=where(finite(boxlists(*,*,ireg)),dumn)
nboxkp=dumn
boxkp=dummy
print,'No. of boxes to keep=',nboxkp
boxts=fltarr(nboxkp,nyrmax*nmon)*!values.f_nan
;
print,'Opening netCDF file and reading 1856-1992 temperature data'
ntime=(1995-1856+1)*nmon
elest=(1856-1400)*nmon
eleen=(1995-1400)*nmon+nmon-1
ncid=ncdf_open('/cru/u2/f055/data/obs/grid/surface/ist_ipcc_18561998.mon.nc')
ncdf_attget,ncid,'airt','missing_value',missv
ncdf_varget,ncid,'airt',fdall,$
  offset=[0.,0.,0.],count=[g.nx,g.ny,ntime]
print,'Altering the missing values to NaN'
misslist=where(fdall eq missv,nmiss)
if nmiss gt 0 then fdall(misslist)=!values.f_nan
print,'Computing regional means'
for ireg = 0 , nreg-1 do begin
  print,'region=',ireg
  print,'Making mask'
  fdmask=boxlists(*,*,ireg)
  print,'Finding mean'
  regts(elest:eleen,ireg)=globalmean(fdall,g.y,mask=fdmask,cover=cover)
  regcover(elest:eleen,ireg)=cover
endfor
print,'Now extracting individual timeseries'
fd=reform(fdall,g.nx*g.ny,ntime)
boxts(*,elest:eleen)=fd(boxkp,*)
ncdf_close,ncid
;
; Now save them
;
x=findgen(nyrmax)+1400.
for ireg = 0 , nreg-1 do begin
  ; extract one region and separate into months, years and then transpose into
  ; year,months
  winstr=reform(regts(*,ireg),nmon,nyrmax)
  winstr=transpose(winstr)
  wcover=reform(regcover(*,ireg),nmon,nyrmax)
  wcover=transpose(wcover)
  save,filename='instrts_'+regname(ireg)+'.idlsave',x,winstr,wcover
endfor
allx=fltarr(g.nx,g.ny)
for i = 0 , g.ny-1 do allx(*,i)=g.x
ally=fltarr(g.nx,g.ny)
for i = 0 , g.nx-1 do ally(i,*)=g.y
boxlon=allx(boxkp)
boxlat=ally(boxkp)
boxts=reform(boxts,nboxkp,nmon,nyrmax)
save,filename='instrboxes.idlsave',x,boxts,boxlon,boxlat
;
end
