;
; Makes N Hemi mean timeseries of instrumental data
;
g=def_grid(/ipcc)
;
; Define arrays
;
nyrmax=1992-1600+1
nmon=12
nhts=fltarr(nyrmax,nmon)+!values.f_nan
;
ncid=ncdf_open('/cru/u2/f055/detect/obsdat/IPCC_tair_18561996.mon.nc')
ncdf_varget,ncid,'year',ipccy
ncdf_varget,ncid,'month',ipccm
ist=where( (ipccy eq 1856) and (ipccm eq 0) )
ien=where( (ipccy eq 1992) and (ipccm eq 11) )
ncdf_varget,ncid,'airt',airt,offset=[0,0,ist],count=[g.nx,g.ny,ien-ist+1]
ncdf_attget,ncid,'airt','missing_value',missval
ncdf_close,ncid
misslist=where(airt eq missval,nmiss)
print,'No. missing=',nmiss
if nmiss gt 0 then airt(misslist)=!values.f_nan
dummy=globalmean(airt,g.y,nhemi=nhmon)
nallt=n_elements(nhmon)
nallyr=nallt/nmon
nhmon=reform(nhmon,nmon,nallyr)
nhts(1856-1600:1992-1600,*) = transpose(nhmon)
;
; Now save them
;
x=findgen(nyrmax)+1600.
save,filename='instrts_nh.idlsave',x,nhts
;
end
