;
; Outputs regional timeseries for Harry
;
; Get region info
;
restore,filename='harryboxes.idlsave'
missval=-99.99
;
; For each region
;
for ireg = 0 , nreg-1 do begin
  ;
  ; Get adjusted instrumental temperature timeseries
  ;
  restore,filename='harryadj_'+regname(ireg)+'.idlsave'
  ;
  if ireg eq 0 then begin
    nt=n_elements(x)
    alldat=fltarr(nreg+1,nt)
    alldat(0,*)=x
  endif
  ;
  misslist=where(finite(instradj) eq 0,nmiss)
  if nmiss gt 0 then instradj(misslist)=missval
  ;
  alldat(ireg+1,*)=instradj
  ;
endfor
;
openw,1,'region_ist.dat'
printf,1,'Instrumental Surface Temperatures (IST) for regions'
printf,1
printf,1,'Temperatures are April-September anomalies, adjusted for variations'
printf,1,'in sample size, and have been normalised over their entire length'
printf,1
printf,1,nreg,'=number of regions',format='(I7,A70)'
printf,1,nt,'=number of years',format='(I7,A70)'
printf,1,missval,'=missing values',format='(F7.2,A70)'
printf,1
printf,1,'Column'
printf,1,1,'year',format='(I7,A70)'
for i = 0 , nreg-1 do printf,1,i+2,regname(i),format='(I7,A70)'
printf,1
printf,1,alldat,format='(I7,9F7.2)'
close,1
;
end
