;
g=def_grid(/ipcc)
;
multi_plot,nrow=5,ncol=2
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif else begin
  device,xsize=15,xoffset=3
  device,ysize=24,yoffset=2
endelse
;
wlims=[-180.,-180.,-180.,-90.,-90.,0.,0.,0.,0.]
elims=[0.,0.,0.,90.,90.,180.,180.,180.,180.]
oxs=0.5*(wlims+elims)
;
map=def_map(/npolar)  &  map.limit(0)=20.
coast=def_coast(/get_device)  &  coast.double=0
labels=def_labels(/off)  &  labels.gridon=1  &  labels.dlon=90.
;
restore,filename='harryboxes.idlsave'
for i = 0 , nreg-1 do begin
;
pause
fd1=boxlists(*,*,i)
dummy=where(finite(fd1),nboxxx)
map.limit(1)=wlims(i)
map.limit(3)=elims(i)
map.origx=oxs(i)
inter_boxfd,fd1,g.x,g.y,map=map,coast=coast,labels=labels,$
  title=regname(i)+'  n='+string(nboxxx,format='(I3)'),$
  levels=[0.5,1.5],c_colors=[100.]
;
endfor
;
end
