;
restore,filename='reglists.idlsave'
;
multi_plot,nrow=4
;
; Ignore 1991 and 1992 (last two values) from all timeseries
;
bs=0.25
for i = 0 , nreg-1 do begin
  restore,filename='densts_'+regname(i)+'.idlsave'
;
; Now normalise w.r.t. 1901-1970
;
  mknormal,wdens,x,refperiod=[1901,1970],refmean=refmean,refsd=refsd
  print,refmean,refsd
;
  keeplist=where(x lt 1991,nkeep)
  y=wdens(keeplist)
  x=x(keeplist)
  yhist=tim_hist(y,binsize=bs,binvals=binvals)
  pause
  binvals=[binvals(0)-bs,binvals]  &  yhist=[0.,yhist]
  plot,binvals,yhist,psym=10,$
    title='Distribution of normalised density anomalies for region: '+$
      regname(i),$
    yrange=[0.,0.15],xrange=[-10,10],$
    xtitle='Density anomaly',$
    ytitle='Frequency'
endfor
;
end
