;
; computes 20degree wide bands of density and temperature timeseries, and
; then correlates and regresses them together.
;
restore,'reglists.idlsave'
;
for i = 0 , nreg-1 , 2 do begin
  ;
  restore,filename='instradj_'+regname(i)+'.idlsave'
  restore,filename='densadj_'+regname(i)+'.idlsave'
  ;
  if i eq 0 then begin
    nts=nreg/2
    ntime=n_elements(densadj)
    fddens=fltarr(nts,ntime)
    fdinstr=fltarr(nts,ntime)
  endif
  a=densadj
  c=instradj
  ;
  restore,filename='instradj_'+regname(i+1)+'.idlsave'
  restore,filename='densadj_'+regname(i+1)+'.idlsave'
  b=densadj
  d=instradj
  ;
  for j = 0 , ntime-1 do begin
fddens(i/2,j)=total( [a(j),b(j)], /nan) / float(total( finite([a(j),b(j)]) ))
fdinstr(i/2,j)=total( [c(j),d(j)], /nan) / float(total( finite([c(j),d(j)]) ))
  endfor
  ;
endfor
;
; Define time and longitude coordinates
;
y=x
x=findgen(nts)*20.+40.
;
rfull=fltarr(nts)
for i = 0 , nts-1 do begin
  ;
  z1=reform(fddens(i,*))
  z2=reform(fdinstr(i,*))
  keeplist=where(finite(z1+z2),nkeep)
  ;
  if nkeep eq 0 then begin
    rfull(i)=!values.f_nan
  endif else begin
    z1=z1(keeplist)
    z2=z2(keeplist)
    rfull(i)=correlate(z1,z2)
  endelse
  ;
endfor
;
end
