;
; plots a hov-mueller of north russian density timeseries, gridded in longitude
; bands.  timeseries have been variance-adjusted and normalised.
;
fname='denshov.idlsave'
dummy=findfile(fname,count=nfile)
if nfile gt 0 then begin
  restore,fname
endif else begin
  restore,'reglists.idlsave'
  ;
  thalf=10.
  for i = 0 , nreg-1 do begin
    ;
    restore,filename='densadj_'+regname(i)+'.idlsave'
    ;
    if i eq 0 then fd=fltarr(nreg,n_elements(densadj))
    ;
    filter_cru,thalf,tsin=densadj,tslow=tslow,/nan
    fd(i,*)=tslow
    ;
  endfor
  ;
  ; Define time and longitude coordinates
  ;
  y=x
  x=findgen(nreg)*10.+35.
  ;
  ; Double the resolution to improve curviness of contours, but then re-select
  ; only the originil time points (so that it is only the spatial res. that is
  ; doubled).
  ;
  fdnew=tim_hires(fd,x,y,xout=xout,yout=yout)
  i=indgen(n_elements(y))*2
  fd=fdnew(*,i)
  x=xout
  ;
  ; smooth spatially too
  ;
  ny=n_elements(y)
  for i = 0 , ny-1 do begin
    oneline=reform(fd(*,i))
    filter_cru,5.,tsin=oneline,tslow=oneout,/nan
    fd(*,i)=oneout
  endfor
  ;
  save,filename=fname
  ;
endelse
;
if !d.name eq 'X' then window,ysize=800
multi_plot,nrow=1,layout='large'
loadct,39
;
levs=[-3.,-2.,-1.,-0.5,-0.2]
levs=[levs,-reverse(levs)]
c_colors=indgen(9)+10.
def_1color,r,g,b,10,color='dblue'
def_1color,r,g,b,13,color='lgreen'
def_smearcolor,r,g,b,fromto=[10,13]
def_1color,r,g,b,14,color='white'
def_1color,r,g,b,15,color='lyellow'
def_1color,r,g,b,18,color='red'
def_smearcolor,r,g,b,fromto=[15,18]
;
;!p.region=[0.,0.1,1.,1.]
contour,fd,x,y,levels=levs,/cell_fill,/xstyle,/ystyle,xrange=[30,170],$
  xtitle='Longitude',ytitle='Year',c_colors=c_colors,yrange=[1430,1992],$
  title='Normalised maximum density anomaly (ref: 1701-1940 filt: 20 yr)'
contour,fd,x,y,levels=levs,/overplot
;!p.region=[0.,0.,1.,0.1]
;!p.multi(0)=1
;scale_horiz,levels=levs,c_colors=c_colors,$
;  xtitle='Normalised maximum density anomaly'
;!p.region=[0.,0.,0.,0.]
;
end
