function rd1yr,yr,lun=ncid,x=x,y=y,frac=frac
;
; Reads in 1 year of the tree ring density station file, directly.
; Opens and closes the default file if necessary, else it uses the currently
; open one specified by ncid.  Station latitude and longitudes are read.
;
if n_elements(ncid) eq 0 then begin
  iclose=1
  ncid=ncdf_open('tree_dens_nh.nc')
endif else begin
  iclose=0
endelse
;
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'year',year
;
ncdf_varget,ncid,'density',data,offset=[yr-year(0),0],count=[1,nstat]
ncdf_varget,ncid,'fraction',frac,offset=[yr-year(0),0],count=[1,nstat]
ncdf_varget,ncid,'latitude',y
ncdf_varget,ncid,'longitude',x
frac=reform(frac)
;
if iclose eq 1 then ncdf_close,ncid
;
return,reform(data)
;
end
