;
; Plots long swedish chronology for Raoul Franklin
;
ndec=231
headlin=' '
rawdat=fltarr(21,ndec)
openr,1,'/cru/keith1/harry/trees/visit/swedabscrns.std'
readf,1,headlin
print,headlin
readf,1,rawdat,format='(6X,I4,I4,I3,I4,I3,I4,I3,I4,I3,I4,I3,I4,I3,I4,I3,'+$
  'I4,I3,I4,I3,I4,I3)'
close,1
;
rawdat2=reform(rawdat(1:20,*),2,10*ndec)
ntree=reform(rawdat2(1,*))
mxdval=reform(rawdat2(0,*))
;
ml=where(mxdval eq 9990,nmiss)
if nmiss gt 0 then mxdval(ml)=!values.f_nan
;
xtime=findgen(2310)-310
;
mknormal,mxdval,xtime,refperiod=[1881,1940]
;
filter_cru,25.,tsin=mxdval,tslow=mxdlow,/nan
;
loadct,39
multi_plot,nrow=4,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
def_1color,10,color='lgrey'
;
nsec=8
secst=-400
seclen=300
;
for i = 0 , nsec-1 do begin
  ;
  secen=secst+seclen-1
  kl=where((xtime ge secst) and (xtime le secen),nkeep)
  x=xtime(kl)
  y=mxdval(kl)
  z=mxdlow(kl)
  ;
  if secen lt 0 then xtitle='Year  (BC)'
  if secst ge 0 then xtitle='Year  (AD)'
  if (secst lt 0) and (secen gt 0) then xtitle='Year  (BC/AD)'
  ;
  pause
  cpl_barts,x,y,/outline,$
    /xstyle,ytitle='Normalised tree-ring density',$
    xrange=[secst,secen],xtitle=xtitle,yrange=[-3,3],/ystyle
  oplot,x,z,thick=3
  ;
  secst=secen+1
  ;
endfor
;
kl=where((xtime ge 90) and (xtime le 210))
x=xtime(kl)
y=mxdval(kl)
z=mxdlow(kl)
xtitle='Year  (AD)'
;
pause
cpl_barts,x,y,/outline,$
  /xstyle,ytitle='Normalised tree-ring density',$
  xtitle=xtitle,yrange=[-3,3],/ystyle
oplot,x,z,thick=3
;
!p.multi(0)=0
plot,xtime,mxdlow,/nodata,/xstyle,xtitle='Year  (BC/AD)',$
  ytitle='Normalised tree-ring density',/ystyle,yrange=[-3,3]
polyfill,[100,200,200,100,100],[!y.crange(0),!y.crange,reverse(!y.crange)],$
  color=10
oplot,!x.crange,[0.,0.],linestyle=1
oplot,xtime,mxdlow,thick=3
;
end
