;
; Plots maps of chronology location, tree type, country
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'country',country
ncdf_varget,ncid,'tree',tree
ncdf_varget,ncid,'latitude',ylat
ncdf_varget,ncid,'longitude',xlon
ncdf_close,ncid
misslist=where(ylat lt 30.,nmiss)
if nmiss gt 0 then ylat(misslist)=!values.f_nan
;
multi_plot,nrow=2
loadct,39
def_1color,r,g,b,10,color='green'
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
endif else begin
  device,xsize=17,xoffset=2
  device,ysize=22,yoffset=4
endelse
;
map=def_map(/npolar)  &  map.limit(0)=30.
coast=def_coast(/off)
labels=def_labels(/off)  &  labels.gridon=1  &  labels.dlon=90.
;
inter_boxfd,/nodata,map=map,coast=coast,labels=labels
map_continents,/coasts,color=!p.color,mlinethick=0.5
map_continents,/countries,color=!p.color,mlinestyle=1,mlinethick=0.5
;
cpl_usersym,/circle,/fill
plots,xlon,ylat,psym=8,color=!p.color
;
plot,[0,1],/noerase,xstyle=4,ystyle=4,/nodata,$
  xmargin=[2,2],ymargin=[2,2]
;  title='Location of density chronologies'
;
end
