;
; Creates a file for submission to the NOAA NGCDC palaeoclimatic database
; Year NHD1 NHLMT NHD2
;
openw,1,'nhd14001994.dat'
  ;
  ; Get data in
  ;
  restore,filename='densadj_MEAN.idlsave'
  timey=x
  nyr=n_elements(densadj)
  nhd1=densadj
  nhlmt=nhd1*0.116626
  restore,filename='densadj_ALL.idlsave'
  nhd2=densadj
  ;
  misslist=where(finite(nhd1+nhd2) eq 0,nmiss)
  if nmiss gt 0 then message,'Ooops1'
  ;
  ; Output it
  ;
  printf,1,' Year        NHD1 NHLMT(est.)        NHD2'
  for j = 0 , nyr-1 do printf,1,timey(j),nhd1(j),nhlmt(j),nhd2(j),$
          format='(I5,3F12.3)'
  close,1
;
end
