;
; Plots n eff as a function of n for various rbar
;
nvals=findgen(11)+1.
endp=n_elements(nvals)-1
rbars=findgen(11)*0.1
;
multi_plot,nrow=1
if !d.name eq 'PS' then device,xsize=13.,ysize=9.
;
plot,/nodata,nvals,$
  xrange=[0.,13.],xstyle=1,xtitle='n',$
  yrange=[0.,1.1],ystyle=1,ytitle='1 / n'+"'"
;
for i = 0 , n_elements(rbars)-1 do begin
  ndash=1./ (nvals/(1.+(nvals-1)*rbars(i)))
  oplot,nvals,ndash
  xyouts,nvals(endp)+0.3,ndash(endp),string(rbars(i),format='(F3.1)')
endfor
;
pause
plot,/nodata,nvals,$
  xrange=[0.,13.],xstyle=1,xtitle='n',$
  yrange=[0.,10.],ystyle=1,ytitle='n'+"'"
for i = 0 , n_elements(rbars)-1 do begin
  ndash=(nvals/(1.+(nvals-1)*rbars(i)))
  oplot,nvals,ndash
  xyouts,nvals(endp)+0.3,ndash(endp),string(rbars(i),format='(F3.1)')
endfor
;
end
