;
; Now get the timeseries to use
;
loadct,39
multi_plot,nrow=3
if !d.name eq 'X' then begin
  window, ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
thalf=30.
;
plot,[0,1],/nodata,$
  /xstyle,xrange=[1400,2000],xtitle='Year',$
  /ystyle,yrange=[-1,0.5],ytitle='Temperature anomaly wrt 1961-90  (!Uo!NC)'
oplot,!x.crange,[0.,0.],linestyle=1
;
alltit="Jones' Northern Hemisphere temperature reconstruction"
; Period to consider
      perst=1400
      peren=1980
      openr,1,'phil_nhrecon.dat'
      nyr=992
      rawdat=fltarr(4,nyr)
      readf,1,rawdat,format='(I5,F7.2,I3,F7.2)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(3,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)
      yr=[0.,0.9]
      ; Convert from normalised values to deg C relative to 1961-1990
      ts=ts*0.521 - 0.1134
filter_cru,thalf,/nan,tsin=ts,tslow=tslow
oplot,timey,tslow,thick=3
;
      alltit="Mann's Northern Hemisphere temperature reconstruction"
      ; Period to consider
      perst=1400
      peren=1980
      openr,1,'mann_nhrecon.dat'
      nyr=596
      headdat=' '
      rawdat=fltarr(2,nyr)
      readf,1,headdat
      readf,1,rawdat,format='(I6,F11.7)'
      close,1
      timey=reform(rawdat(0,*))
      ts=reform(rawdat(1,*))
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)-0.12        ; convert to oC wrt 1961-90
      yr=[0.,0.5]
filter_cru,thalf,/nan,tsin=ts,tslow=tslow
oplot,timey,tslow,thick=6
;
      alltit="Age-banded density NH growing-season reconstruction"
      ; Period to consider
      perst=1500
      peren=1960
      restore,filename='../treeharry/densadj_all(330).idlsave'
      timey=x
          ; CONVERSION FACTORS FOR AGE-BANDED MXD, BY REGRESSION ON INSTR.
      ts=densall*0.151434    ; converts it from density to temperature anom
      kl=where((timey ge perst) and (timey le peren),nyr)
      timey=timey(kl)
      ts=ts(kl)-0.139      ; convert to oC wrt 1961-90
      yr=[0.,0.5]
openw,1,'ageband_density.dat'
printf,1,'Temperature reconstruction based on age-banded analysis of'
printf,1,'tree-ring-density records from the Northern Hemisphere'
printf,1
printf,1,'Reconstruction has been calibrated to yield estimates of'
printf,1,'average April-September temperatures from the northern hemisphere'
printf,1,'land north of 20N, with respect to the 1961-1990 average'
printf,1
printf,1,'Year   Temperature estimate (degrees C)'
for ijk = 0 , n_elements(ts)-1 do printf,1,timey(ijk),ts(ijk),format='(I4,F10.2)'
close,1
filter_cru,thalf,/nan,tsin=ts,tslow=tslow
oplot,timey,tslow,thick=5,linestyle=2
;
legend,/horiz,['Mann et al. 1998','Jones et al. 1998','Briffa et al.'],$
  linestyle=[0,0,2],thick=[6,3,5]
;
end
