;
; Plots distributions and cutoffs of trends and means of different length
; segments.
;
; Get pre-analysed data
;
restore,filename='trendmean_distrib.idlsave'
;  ntry,tlen,nts,alltit,tren95,mean95,binmean,bintren,freqmean,freqtren,$
;  nbin,binsc
;
; Prepare window/paper for plotting
;
loadct,39
multi_plot,nrow=2,ncol=2,/landscape
if !d.name eq 'X' then begin
  window, xsize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
;
; Select which distributions to show
;
iuse=[2,6,12]
nuse=n_elements(iuse)
;
; Compute distribution totals for scaling by
;
fmtot=total(freqmean,1)/100.
fttot=total(freqtren,1)/100.
;
; Repeat for each time series
;
for its = 0 , nts-1 do begin
  ;
  pause
  plot,binmean*binsc(its),freqmean(*,iuse(0),its,0),/nodata,$
    /xstyle,xtitle='Mean anomaly  (!Uo!NC)',$
    /ystyle,ytitle='Frequency of occurrence!C(%)',yrange=[0.,50.]
  oplot,[0.,0.],!y.crange,linestyle=1
  ;
  for j = 0 , nuse-1 do begin
    oplot,binmean*binsc(its),freqmean(*,iuse(j),its,0)/fmtot(iuse(j),its,0),$
      thick=4
    oplot,binmean*binsc(its),freqmean(*,iuse(j),its,1)/fmtot(iuse(j),its,1)
  endfor
  ;
  xyouts,/normal,0.5,0.99,align=0.5,alltit(its)
  ;
  plot,bintren*binsc(its),freqtren(*,iuse(0),its,0),/nodata,$
    /xstyle,xtitle='Trend  (!Uo!NC per segment length)',$
    /ystyle,ytitle='Frequency of occurrence!C(%)',yrange=[0.,50.]
  oplot,[0.,0.],!y.crange,linestyle=1
  ;
  for j = 0 , nuse-1 do begin
    oplot,bintren*binsc(its),freqtren(*,iuse(j),its,0)/fttot(iuse(j),its,0),$
      thick=4
    oplot,bintren*binsc(its),freqtren(*,iuse(j),its,1)/fttot(iuse(j),its,1)
  endfor
  ;
  if its le 2 then yr=[0.,0.3] else yr=[0.,1.0]
  plot,tlen,mean95(*,its,0),thick=4,psym=-def_sym(10),$
    /xstyle,xtitle='Segment length  (years)',$
    ytitle='95th centile of segment means!C(!Uo!NC)',$
    /ystyle,yrange=yr
  oplot,tlen,mean95(*,its,1),psym=-def_sym(15)
  ;
  if its le 2 then yr=[0.,0.6] else yr=[0.,2.6]
  plot,tlen,tren95(*,its,0),thick=4,psym=-def_sym(10),$
    /xstyle,xtitle='Segment length  (years)',$
    ytitle='95th centile of segment trends!C(!Uo!NC per segment length)',$
    /ystyle,yrange=yr
  oplot,tlen,tren95(*,its,1),psym=-def_sym(15)
  ;
endfor
;
end
