;
; SAME AS plotcorr_nhemi.pro BUT TO TEST MY NEW mkcorrelation.pro FUNCTION
;
; Computes correlations on full, high and low pass timeseries of density
; anomalies against full NH temperatures.
;
restore,filename='reglists.idlsave'
nreg=8       ; avoid Artic and extra-Arctic regions!
;
; Read in timeseries and compute correlations
;
perst=1881.
peren=1961.
;
openw,1,'corr_nhemi.out'
thalf=10.
printf,1,'Correlations between timeseries'
printf,1,'               NH temp. vs. MXD    NH temp. vs. TRW'+$
  ' NH temp. vs. instr.'
printf,1,'     Region    Full  High   Low    Full  High   Low'+$
  '    Full  High   Low'
;
restore,'instrts_nh.idlsave'
totval=total(nhts(*,3:8),2,/nan)
totn=total(finite(nhts(*,3:8)),2)
keeplist=where(totn gt 0,nkeep)
lvx=x
lvy=totval*!values.f_nan
lvy(keeplist)=totval(keeplist)/float(totn(keeplist)) 
filter_cru,thalf,tsin=lvy,tslow=lvylow,tshigh=lvyhi,/nan
;
for i = 0 , nreg-1 do begin
  print,i
  ;
  restore,filename='densadj_'+regname(i)+'.idlsave'
  y1=densadj
  ;
  restore,filename='instradj_'+regname(i)+'.idlsave'
  y3=instradj
  ;
  if total(abs(lvx-x)) ne 0 then message,'Incompatible years'
  ;
  rrr=mkcorrelation(y1,lvy,x,filter=thalf,refperiod=[perst,peren])
  r1=rrr(0)
  r2=rrr(1)
  r3=rrr(2)
  ;
  rrr=mkcorrelation(y3,lvy,x,filter=thalf,refperiod=[perst,peren])
  r7=rrr(0)
  r8=rrr(1)
  r9=rrr(2)
  ;
  r4=!values.f_nan & r5=r4 & r6=r4
  printf,1,regname(i),r1,r2,r3,r4,r5,r6,r7,r8,r9,$
      format='(A11,3(2X,3F6.2))'
  ;
endfor
;
printf,1,' '
printf,1,'Correlations carried out over the period ',perst,peren
printf,1,' '
printf,1,'To separate low and high frequency components, a gaussian weighted'
printf,1,'filter was used with a half-width (years) of ',thalf
;
close,1
;
end
