;
; Plots mean timeseries of instrumental data
;
multiplot,4
loadct,39
def_1color,r,g,b,1,color='red'
def_1color,r,g,b,2,color='blue'
if !d.name eq 'X' then begin
  window,ysize=900
endif else begin
  device,xoffset=2,xsize=17
endelse
;
; Get region info
;
restore,filename='regboxes.idlsave'
g=def_grid(/ipcc)
;
; Define arrays
;
nyrmax=1994-1400+1
nmon=12
regts=fltarr(nyrmax*nmon,nreg)+!values.f_nan
regcover=fltarr(nyrmax*nmon,nreg)
;
; Now also want to keep groups of grid-box timeseries for the boxes that go
; into each regional mean
;
; Region 0 is ALL
ireg = 0
dummy=where(finite(boxlists(*,*,ireg)),dumn)
nboxkp=dumn
boxkp=dummy
print,'No. of boxes to keep=',nboxkp
boxts=fltarr(nboxkp,nyrmax*nmon)*!values.f_nan
;
print,'Opening netCDF file and reading 1856-1994 temperature data'
ntime=(1994-1856+1)*nmon
elest=(1856-1400)*nmon
eleen=(1994-1400)*nmon+nmon-1
ncid=ncdf_open('/cru/dave3/f055/detect/obsdat/tair_monthly.nc')
ncdf_attget,ncid,'temperature','missing_value',missv
ncdf_varget,ncid,'temperature',fdall,$
  offset=[0.,0.,0.],count=[g.nx,g.ny,ntime]
print,'Altering the missing values to NaN'
misslist=where(fdall eq missv,nmiss)
if nmiss gt 0 then fdall(misslist)=!values.f_nan
print,'Computing regional means'
for ireg = 0 , nreg-1 do begin
  print,'region=',ireg
  print,'Making mask'
  fdmask=boxlists(*,*,ireg)
  print,'Finding mean'
  regts(elest:eleen,ireg)=globalmean(fdall,g.y,mask=fdmask,cover=cover)
  regcover(elest:eleen,ireg)=cover
endfor
print,'Now extracting individual timeseries'
fd=reform(fdall,g.nx*g.ny,ntime)
print,'X'
boxts(*,elest:eleen)=fd(boxkp,*)
print,'X'
ncdf_close,ncid
print,'X'
;
; Now save them
;
x=findgen(nyrmax)+1400.
print,'X'
for ireg = 0 , nreg-1 do begin
  print,ireg
  ; extract one region and separate into months, years and then transpose into
  ; year,months
  winstr=reform(regts(*,ireg),nmon,nyrmax)
  winstr=transpose(winstr)
  wcover=reform(regcover(*,ireg),nmon,nyrmax)
  wcover=transpose(wcover)
  save,filename='nc.instrts_'+regname(ireg)+'.idlsave',x,winstr,wcover
endfor
print,'X'
allx=fltarr(g.nx,g.ny)
print,'X'
for i = 0 , g.ny-1 do allx(*,i)=g.x
print,'X'
ally=fltarr(g.nx,g.ny)
print,'X'
for i = 0 , g.nx-1 do ally(i,*)=g.y
print,'X'
boxlon=allx(boxkp)
print,'X'
boxlat=ally(boxkp)
print,'X'
boxts=reform(boxts,nboxkp,nmon,nyrmax)
print,'X'
save,filename='nc.instrboxes.idlsave',x,boxts,boxlon,boxlat
;
end
