;
; Computes rbar for longvolv record
;
ncid=ncdf_open('longvolc.nc')
ncdf_diminq,ncid,'time',dummy,ntime
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'year',x
ncdf_varget,ncid,'density',density
ncdf_attget,ncid,'density','missing_value',valmiss
ncdf_varget,ncid,'fraction',weight
ncdf_close,ncid
;
; Reduce length of it
;
;help,density,x
;keeplist=where(x ge 1856,nkeep)
;if nkeep gt 0 then begin
;  density=density(keeplist,*)
;  x=x(keeplist)
;endif
;help,density,x
;
misslist=where(density eq valmiss,nmiss)
density(misslist)=!values.f_nan
;
; Use all three trees for this record
;
nsize=nstat
inx=density(*,*)
;
; Define a correlation matrix
;
grandr=fltarr(nsize,nsize)
;
; Do each tree against all others (including itself)
;
for j = 0 , nsize-1 do begin
;  print,j
  iny=reform(inx(*,j))
  rowr=manycorr(inx,iny,/nan,nval=nval)     ; compute r values
  grandr(*,j)=rowr(*)
endfor
;
; Total it and average it, but only do i<>j.
;
totr=0.
totn=0.
for j = 1 , nsize-1 do begin
  for k = 0 , j-1 do begin
    if finite(grandr(j,k)) then begin
      totr=totr+grandr(j,k)
      totn=totn+1.
      if grandr(j,k) eq 1. then message,'Ooops!'
    endif
  endfor
endfor
totr=totr/totn
;
allrbar=totr
;
print,'RBAR calculations for longvolc record'
print
print,'RBAR'
print,allrbar
print
print,'Correlation matrix'
print,grandr
;
save,filename='rbar_longvolc.idlsave',allrbar
;
end
