;
; Plots maps of correlations between MXD and Apr-Sep temperature and
; May-Aug precipitation.
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
endelse
def_1color,19,color='white'
def_1color,20,color='green'
def_1color,21,color='deepblue'
def_1color,22,color='purple'
def_1color,23,color='red'
def_1color,24,color='black'
def_1color,30,color='mgrey'
cpl_usersym,/circle,/fill
;
map=def_map(/npolar)  &  map.limit(0)=25.
map.xmargin=[0,0] & map.ymargin=[0,0]
coast=def_coast(/get_device) & coast.double=0
labels=def_labels(/off)
;
;trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
for trv = 0 , 1 do begin
case trv of
  0: begin
    fnadd='mxd'
    iseas=18
    end
  1: begin
    fnadd='trw'
    iseas=20
    end
endcase
titadd=strupcase(fnadd)
;
; Repeat for full, early and late periods
;
for iper = 0 , 0 do begin
  ;
  ; Restore all correlations
  ;
  case iper of
    0: restore,filename=fnadd+'_moncorr.idlsave'
    1: restore,filename=fnadd+'_moncorr_early.idlsave'
    2: restore,filename=fnadd+'_moncorr_late.idlsave'
  endcase
  ;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon
  ;
  mtit='   (1881-1984)'
  ;
  ; Plot temperature correlations
  ;
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;    title='r( MXD , April-September temp.)'+mtit
  ;
  oner=reform(allr(*,iseas,1))
  ;
  if !d.name eq 'PS' then device,font_size=10
  ;
  cpl_usersym,/circle,/fill
  plots,statlon,statlat,psym=8,color=19
  ;
  wl=where(oner lt 0.22,nwhite)
  if nwhite gt 0 then plots,statlon(wl),statlat(wl),psym=def_sym(15)
  ;
  gl=where((oner ge 0.22) and (oner lt 0.4),ngreen)
  if ngreen gt 0 then plots,statlon(gl),statlat(gl),psym=def_sym(1)
  ;
  pl=where((oner ge 0.4) and (oner lt 0.5),npurple)
  if npurple gt 0 then plots,statlon(pl),statlat(pl),psym=def_sym(2)
  ;
  rl=where((oner ge 0.5) and (oner lt 0.6),nred)
  if nred gt 0 then plots,statlon(rl),statlat(rl),psym=def_sym(16)
  ;
  bl=where(oner ge 0.6,nblack)
  if nblack gt 0 then plots,statlon(bl),statlat(bl),psym=def_sym(10)
  ;
  if !d.name eq 'PS' then device,font_size=11
;
legpos=convert_coord([-143.],[26.],/data,/to_normal)
  ;
if !d.name eq 'PS' then device,/courier,/bold,font_size=10
legend,$
  ['r('+titadd+','+corrname(iseas)+' temp.) 1881-1984',$
   'r <  +0.22         (N='+string(nwhite,format='(I3)')+')',$
   'r =  +0.22 to +0.4 (N='+string(ngreen,format='(I3)')+')',$
   'r =  +0.4  to +0.5 (N='+string(npurple,format='(I3)')+')',$
   'r =  +0.5  to +0.6 (N='+string(nred,format='(I3)')+')',$
   'r >  +0.6          (N='+string(nblack,format='(I3)')+')'],$
  linestyle=[-1,0,0,0,0,0],psym=[-1,15,1,2,16,10],position=legpos,$
  charsize=0.85,spacing=1.25,margin=[0.45]
if !d.name eq 'PS' then device,/helvetica,/bold,font_size=11
;
endfor
;
endfor
;
end
