;
; Combines the calibrated regional series of Hugershoff and Age-Banded
; MXD records
;
thalfwant=25.         ; threshold for combining the series
donh=1                ; 0=NH 1=ALL
;
if donh eq 0 then begin
  regtit='NH'
endif else begin
  regtit='ALL'
endelse
;
; Read in the age-banded calibrated series ERRORS
;
;restore,filename='bandtemp'+regtit+'_multipcr_errors.idlsave'
; Gets: dosmooth,thalf,calregse,regname,timey, etc.
;if dosmooth eq 0 then message,'Need smoothed errors!'
;if thalf ne thalfwant then $
;  message,'Need time-dep age errors for appropriately smoothed data'
;if regname(nreg-1) ne regtit then $
;  message,'Need time-dep age errors for appropriate region (ALL or NH)'
;
; Read in the Hugershoff calibrated series
;
restore,filename='regtemp_calibrated.idlsave'
; Gets: nyr,nreg,calregts,regname,timey,tempregts,tempnyr,temptimey
if regname(nreg-1) ne regtit then $
  message,'Need to calibrate the Hug MXD for appropriate region'
hugts=reform(calregts(*,nreg-1))
hugts=[hugts,!values.f_nan]      ; pad 'cos agebanded has 1995 value too
tempts=reform(tempregts(*,nreg-1))
;
; Read in the age-banded calibrated series
;
restore,filename='bandtemp'+regtit+'_calmultipcr.idlsave'
; Gets: nyr,nhtit,yrmxd,prednh
bandts=prednh
;
; Prepare for plotting
;
loadct,39
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,20,color='lsand'
def_1color,21,color='lyellow'
def_1color,22,color='red'
def_1color,23,color='mblue'
def_1color,24,color='lgreen'
;
; Combine the low-freq band with high-freq Hug
;
thalf=thalfwant
filter_cru,/nan,thalf,tsin=hugts,tshigh=hughi,tslow=huglow
filter_cru,/nan,thalf,tsin=bandts,tslow=bandlo
filter_cru,/nan,thalf,tsin=tempts,tslow=templo
prednh=bandlo+hughi
;
  print,regtit
  filter_cru,25.,/nan,tsin=bandts,tshigh=a25
  filter_cru,25.,/nan,tsin=hugts,tshigh=h25
  rrr=mkcorrelation(a25,h25,yrmxd)
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1881,1960])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1400,1880])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1400,1499])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1500,1599])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1600,1699])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1700,1799])]
  rrr=[rrr,mkcorrelation(a25,h25,yrmxd,refperiod=[1800,1899])]
  print,'Hi-pass r(age,hug)=',string(rrr,format='(8F8.2)')
;
cpl_barts,yrmxd,prednh,zeroline=bandlo,$
  /xstyle,xtitle='Year',$
  ytitle='Estimated '+regtit+' temperature  (!Uo!NC wrt 1961-90)'
oplot,!x.crange,[0.,0.],linestyle=1
oplot,yrmxd,huglow,thick=2
oplot,temptimey,templo,thick=8
oplot,temptimey,templo,thick=4,color=!p.background
oplot,temptimey,templo
oplot,yrmxd,bandlo,thick=5
;
nhtit=regtit
save,filename='combtemp'+regtit+'_calibrated.idlsave',$
  nhtit,nyr,yrmxd,prednh
;
end
