;
; Plots various versions of the NH reconstruction using age-banded.
;
nver=9
doreg='ALL'
docol=0          ; 0=b&w 1=col
;
; First, allsites
;
restore,filename='bandalltemp_calibrated.idlsave'
; Gets: nyr,nhtit,timey,nhtemp
if nhtit ne doreg then message,'Re-calibrate the age-banded!'
;
nyrnh=nyr
timeynh=timey
allts=fltarr(nyrnh,nver) & allts(*,*)=!values.f_nan
allts(*,0)=nhtemp(*)
;
; Next, various versions of the regional combination
;
for iver = 2 , 7 do begin
  ;
  fn='ver'+string(iver,format='(I1)')+'_nhrecon.idlsave'
  print,fn
  restore,filename=fn
  ; Gets: calregts,nreg,nyr,regname,tempnyr,temptimey,tempregts,timey
;  if regname(nreg-1) ne doreg then message,'Re-calibrate the age-banded!'
  if regname(nreg-1) ne doreg then print,regname(nreg-1)
  allts(*,iver-1)=calregts(*,nreg-1)
  ;
endfor
;
; Now for the PCR reconstruction
;
;restore,filename='bandtempNH_calmultipcr.idlsave'
restore,filename='bandtempALL_calmultipcr.idlsave'
; Gets: nyr,nhtit,yrmxd,prednh,fullnh
if nhtit ne doreg then message,'Re-calibrate the age-banded!'
;allts(*,7)=fullnh(*)
allts(*,7)=prednh(*)
;
thalf=25.       ; filter for high or low-pass
;
if docol ne 0 then begin
  lcol=[10,11,12,13,14,15,16,17]
  lthi=[ 2, 4, 4, 4, 4, 4, 4, 4]
endif else begin
  lcol=[10,10,10,10,10,10,10,10]
  lthi=[ 1, 1, 1, 1, 1, 1, 1, 4]
endelse
;
loadct,39
multi_plot,nrow=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=900
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,bold=0,font_size=14
endelse
def_1color,10,color='black'
def_1color,11,color='mdyellow'
def_1color,12,color='lblue'
def_1color,13,color='orange'
def_1color,14,color='deepblue'
def_1color,15,color='red'
def_1color,16,color='vlpurple'
def_1color,17,color='lgreen'
;
plot,[0,1],/nodata,$
  /xstyle,xrange=[1400,1960],xtitle='Year',$
;  /ystyle,yrange=[-0.85,0.3],ytitle='Temperature anomaly  (!Uo!NC wrt 1961-90)'
  /ystyle,yrange=[-1.1,0.4],ytitle='Temperature anomaly  (!Uo!NC wrt 1961-90)'
oplot,!x.crange,[0.,0.],linestyle=1
;
for iver = 0 , nver-1 do begin
  y=allts(*,iver)
  filter_cru,thalf,/nan,tsin=y,tslow=ylow
  oplot,timeynh,ylow,thick=lthi(iver),color=lcol(iver)
endfor
;
y=tempregts(*,nreg-1)
filter_cru,thalf,/nan,tsin=y,tslow=ylow
oplot,temptimey,ylow,thick=7,linestyle=1
;
if docol ne 0 then begin
  legend,['1','2','3','4','5','6','7','8','Observed'],$
    thick=[lthi,5],$
    color=[lcol,!p.color],/horiz,pspacing=2.5
endif
;
end
