;
; Restores NH and ALL time series and correlates them (high, low & raw).
; And with the full NH land+marine series too!
;
restore,filename='compbest_mxd_fixed1950.idlsave'
nhtemp=reform(comptemp(*,3))
alltemp=reform(comptemp(*,2))
;
print,'Reading in IPCC global IST gridded data'
ncid=ncdf_open('/cru/u2/f055/data/obs/grid/surface/ist_ipcc_18561998.mon.nc')
fdmon=crunc_rddata(ncid,tst=[1860,0],tend=[1994,11],grid=g,info=i)
ncdf_close,ncid
; Compute annual means
nmon=12
istnyr=g.nt/nmon
if istnyr ne n_elements(nhtemp) then message,'Ooops!'
fdmon=reform(fdmon,g.nx,g.ny,nmon,istnyr)
fdsum=total(fdmon,3,/nan)
fdnum=total(finite(fdmon),3)
fdann=fdsum/float(fdnum)
; Compute hemispheric mean
dummy=globalmean(fdann,g.y,nhemi=landmarine)
;
print,mkcorrelation(alltemp,nhtemp,filter=10)
print,mkcorrelation(alltemp,nhtemp,timey,refperiod=[1881,1960],filter=10)
print,mkcorrelation(alltemp,landmarine,filter=10)
print,mkcorrelation(alltemp,landmarine,timey,refperiod=[1881,1960],filter=10)
print,mkcorrelation(nhtemp,landmarine,filter=10)
print,mkcorrelation(nhtemp,landmarine,timey,refperiod=[1881,1960],filter=10)
;
end
