;
; Plots regional-mean observations of temperature on a month by month basis
;
; Define regions list
;
regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP','WNA','NWNA','ECCA']
nreg=n_elements(regname)
monname=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep']
doreg=[1,0,1,1,0,0,0,1,1]
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
;
for ireg = 0 , nreg-1 do begin
 if doreg(ireg) eq 1 then begin
  ;
  restore,'regobs_'+regname(ireg)+'.idlsave'
  ; Gets latmon,premon,timey,nmon,nyr
  ;
  pause
  plot,timey,latmon(5,*),/nodata,$
    /xstyle,xtitle='Year',xmargin=[8,6],$
    /ystyle,yrange=[-20,4],ytitle='Temperature anomaly  (!Uo!NC)',$
    title=regname(ireg)
  ;
  for imon = 3 , 8 do begin
    ifac=float(imon-3)*3.2
    yyy=reform(latmon(imon,*))-ifac
    filter_cru,10.,/nan,tsin=yyy,tslow=ylow
    oplot,timey,yyy,thick=2
    oplot,timey,ylow,thick=5
    oplot,!x.crange,-[ifac,ifac],linestyle=1
    kl=where(finite(yyy),nkeep)
    if imon gt 3 then print,correlate(yyy(kl),yold(kl))
    lastval=yyy(kl(nkeep-1))
    xyouts,1995,lastval,monname(imon)
    yold=yyy
  endfor
  ;
 endif
endfor
;
end
