;
; Computes trends in winter diurnal temperature range from New et al.
; Analysis period is 1960-1995.
;
;----------------------------------------------------
;
print,'Reading DTR data'
ncid=ncdf_open('/cru/u2/f055/data/obs/grid/surface/dtr_new_19011995.mon.nc')
pmon=crunc_rddata(ncid,tst=[1960,0],tend=[1995,11],grid=g)
ncdf_close,ncid
;
; Make DJFM seasonal means
;
nmon=12
nyr=g.nt/nmon
timey=reform(g.year,nmon,nyr)
timey=timey(0,*)
pmon=reform(pmon,g.nx*g.ny,nmon,nyr)
djfmdtr=mkseason(pmon,11,2)
djfmdtr=reform(djfmdtr,g.nx,g.ny,nyr)
;
; Now compute trends
;
trenfd=fltarr(g.nx,g.ny)*!values.f_nan
for ix = 0 , g.nx-1 do begin
  print,ix,format='($,I4)'
  for iy = 0 , g.ny-1 do begin
    ;
    onets=reform(djfmdtr(ix,iy,*))
    kl=where(finite(onets),nkeep)
    if nkeep gt 20 then begin
      acoeff=linfit(timey(kl),onets(kl))
      trenfd(ix,iy)=acoeff(1)*10.    ; deg C per decade
    endif
    ;
  endfor
endfor
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=2,layout='large'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
def_1color,20,color='black'
def_1color,21,color='lpurple'
def_1color,24,color='deepblue'
def_1color,29,color='vlblue'
def_smearcolor,fromto=[21,24]
def_smearcolor,fromto=[24,29]
def_1color,30,color='lsand'
def_1color,33,color='orange'
def_1color,36,color='red'
def_1color,37,color='brown'
def_1color,43,color='black'
def_smearcolor,fromto=[30,33]
def_smearcolor,fromto=[33,36]
def_smearcolor,fromto=[37,43]
def_smearcolor,fromto=[36,39]
;
map=def_map() & map.limit=[30,-15,70,45] & map.origx=15.
labels=def_labels(/off)
levs=findgen(21)*0.05-0.5
cols=indgen(20)+20
;
inter_boxfd,trenfd,g.x,g.y,$
  map=map,labels=labels,$
  /scale,levels=levs,c_colors=cols,$
  title='DJFM diurnal temp range (1961-95)  (!Uo!NC/decade)'
;
end
