;
; Plots the grid box coverage of the complete MXD data for the 1697-1976
; analysis period.
;
useper=[1697,1976]
;
; Restore MXD gridded dataset
;
print,'Reading in MXD data'
restore,filename='calibmxd5.idlsave'
;  g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
;
; Extract required period and locate boxes with complete data
;
print,'Finding spatial and temporal coverage'
kmxd=where((mxdyear ge useper(0)) and (mxdyear le useper(1)),mxdnyr)
mxdyear=mxdyear(kmxd)
fdcalibu=fdcalibu(*,*,kmxd)
fdmask=total(fdcalibu,3)*0.+1.
kmask=where(finite(fdmask),nmask)
print,'NYR=',mxdnyr,'  NBOX=',nmask
;
; Now plot them
;
loadct,39
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/bold,/helvetica,font_size=14
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/get_device)
coast.thick=[1.,2.]
labels=def_labels(/off)
;
levs=[0.5,1.5]
cols=[50]
def_1color,cr,cg,cb,50,color='mdgrey'
;
inter_boxfd,fdmask,g.x,g.y,$
  map=map,coast=coast,labels=labels,$
  levels=levs,c_colors=cols
;
end
