;
; Plots (1 at a time) yearly maps of calibrated (PCR-infilled or not) MXD
; reconstructions
; of growing season temperatures.  Uses "corrected" MXD - but shouldn't usually
; plot past 1960 because these will be artificially adjusted to look closer to
; the real temperatures.
;
doinfill=1
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=1,layout='centred'
if !d.name eq 'X' then begin
  window,ysize=300,xsize=300
  !p.font=-1
  !p.charsize=!p.charsize*1.5
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
;
; Define map parameters
;
map=def_map(/npolar) & map.limit(0)=25 & map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2.5]
levs=[-100,-2,-1.2,-0.8,-0.4,-0.2,0,0.3,0.6,1,100]
cols=indgen(10)+20
;
; Get the calibrated data
;
if doinfill eq 0 then begin
  restore,'calibmxd5.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
endif else begin
  restore,'calibmxd5_pcr.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
endelse
;
for iyr = 0 , 49 do begin
  fd=reform(fdcalibc(*,*,iyr))
  ;
  inter_boxfd,fd,g.x,g.y,$
    coast=coast,map=map,labels=labels,$
    levels=levs,c_colors=cols
  xyouts,-47,28,string(mxdyear(iyr),format='(I4)')
  lon_polar,map=map,[-135.,-45.,45.,135.]
  ;
endfor
;
;!p.multi(0)=1
;!p.position=[0.3,0.015,0.7,ykey-0.015]
;scale_horiz,levels=levs,c_colors=cols,noextremes=['Below','Above'],$
;  title='!Uo!NC wrt 1961-90'
;
end
