;
; Plots location of MXD grid boxes with complete 1697-1976 data,
; differentiating those that were infilled.
;
trv=1           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    end
  1: begin
    fnadd='trw'
    end
endcase
titadd=strupcase(fnadd)
;
restore,fnadd+'_infill.idlsave'
;
shyr=[beglist,1950,reverse(endlist)]
nshow=n_elements(shyr)
;
loadct,39
multi_plot,nrow=3,ncol=5,layout='large',/landscape
if !d.name eq 'X' then begin
  window,xsize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
def_1color,cr,cg,cb,10,color='mlgrey'
def_1color,cr,cg,cb,11,color='black'
;
map=def_map(/npolar)  &  map.limit(0)=15.
map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2]
;
for i = 0 , nshow-1 do begin
  ;
  iyr=where(mxdyear eq shyr(i))
  fd1=reform(mxdfd(*,*,iyr))
  fd2=reform(mxdfd2(*,*,iyr))
  fd=fd1
  fd(*,*)=!values.f_nan
  fd(where(finite(fd2)))=1.
  fd(where(finite(fd1)))=2.
  ;
  inter_boxfd,fd,g.x,g.y,levels=[0.5,1.5,2.5],c_colors=[11,10],$
    labels=labels,map=map,coast=coast
  ;
  xyouts,-55,25,string(shyr(i),format='(I4)')
  ;
endfor
;
multi_plot,nrow=2,/landscape
pause
;
y1=total(finite(mxdfd2),1)
y1=total(y1,1)
y2=total(finite(mxdfd),1)
y2=total(y2,1)
cpl_barts,mxdyear,y2,bar_color=10,$
  /xstyle,xtitle='Year',$
  /ystyle,yrange=[0,120],ytitle='Number of grid boxes with '+titadd+' data'
oplot,mxdyear,y1,psym=10,thick=3
;
end
